/*
 * Decompiled with CFR 0.152.
 */
package z;

public class Vector3D {
    public static final byte DIMENSION = 3;
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte Z = 2;
    private float x;
    private float y;
    private float z;

    public Vector3D() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3D(float xCoord, float yCoord, float zCoord) {
        this.x = xCoord;
        this.y = yCoord;
        this.z = zCoord;
    }

    public Vector3D(float[] tupla3D) {
        if (tupla3D.length != 3) {
            System.out.println("Invavid arguments - tupla3D has an invalid length");
        } else {
            this.x = tupla3D[0];
            this.y = tupla3D[1];
            this.z = tupla3D[2];
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float xPos) {
        this.x = xPos;
    }

    public void setY(float yPos) {
        this.y = yPos;
    }

    public void setZ(float zPos) {
        this.z = zPos;
    }

    public final void setPosition(float xPos, float yPos, float zPos) {
        this.x = xPos;
        this.y = yPos;
        this.z = zPos;
    }

    public float[] getTuple() {
        float[] tuple = new float[]{this.x, this.y, this.z};
        return tuple;
    }

    public void add(Vector3D v) {
        if (v != null) {
            this.x += v.x;
            this.y += v.y;
            this.z += v.z;
        }
    }

    public void scalarMul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public static Vector3D add(Vector3D v, Vector3D w) {
        return new Vector3D(v.x + w.x, v.y + w.y, v.z + w.z);
    }

    public static final Vector3D scalarDiv(Vector3D v, float scalar) {
        if (scalar == 0.0f) {
            System.out.println("ERROR - Division by ZERO");
        }
        float newX = v.x / scalar;
        float newY = v.y / scalar;
        float newZ = v.z / scalar;
        return new Vector3D(newX, newY, newZ);
    }

    public static final float magnitude(Vector3D v) {
        return (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
    }

    public static final float euclideanDistance(Vector3D v, Vector3D w) {
        float dx = v.x - w.x;
        float dy = v.y - w.y;
        float dz = v.z - w.z;
        dx *= dx;
        dy *= dy;
        dz *= dz;
        return (float)Math.sqrt(dx + dy + dz);
    }
}

