/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.Console;
import z.GameEngine;
import z.Input;
import z.Math3D;
import z.PWTokenizer;
import z.Resources;
import z.SniperCanvas;
import z.SniperMIDlet;
import z.SpriteObject;

public class MenuCanvas
extends Canvas
implements Runnable {
    private static final long TIME_IN = 300L;
    private static final long TIME_OUT = 300L;
    private static final int _OPTIONS_IN_ = 0;
    private static final int _OPTIONS_STATIC_ = 1;
    private static final int _OPTIONS_OUT_ = 2;
    public static final int MENU_ADDT_INIT_Y = 20;
    private static final int MAP_X_OFFSET = 0;
    private static final int FLAG_W = 29;
    private static final int FLAG_H = 20;
    private static final int FLAG_GAP = 5;
    private static final int FLAG_X = 105;
    private static final int FLAG_Y = 145;
    private static final short BANNER_HEIGHT = 30;
    private static final short _Up_Banner_Y_ = 0;
    private static final short _Down_Banner_Y_ = 290;
    public static final int _Title_X_ = 48;
    public static final int _Title_Y_ = 49;
    public static final int _Title_W_ = 68;
    public static final int _Title_H_ = 16;
    public static final int _Result_H_ = 78;
    public static final int _Result_Y_ = 84;
    public static final int _Result_X1_ = 36;
    public static final int _Result_X2_ = 123;
    public static final int _Result_W1_ = 67;
    public static final int _Result_W2_ = 26;
    private static final int _VolumenBar_X_ = 95;
    private static final int _VolumenBar_Y_ = 235;
    private static final int _VolumenSlots_ = 10;
    private static final int _VolumenSlotW_ = 4;
    private static final int _VolumenSlotH_ = 12;
    private static final int _VolumenSlotGap_ = 3;
    private static final int _LowVolumenColor_ = -16711936;
    private static final int _MediumVolumenColor_ = -256;
    private static final int _HighVolumenColor_ = -65536;
    private static final byte LETTERS_PER_ROW = 8;
    private static final byte NAME_SIZE = 10;
    private static final byte margin_L_R = 10;
    private static final byte margin_Down = 5;
    private static final byte margin_Up = 10;
    private static final String[] CHEATS = new String[]{"GODMODE", "BULLETX", "GIVEMEALL"};
    private static final int _Rectangle_Color_ = -8421505;
    private static final int _Growing_Time_ = 700;
    private static final int _Blinking_Time_ = 700;
    private static final int _Skip_Image_Y_Pos = 298;
    private static final int _Skip_Image_X_Left_Pos = 6;
    private static final int _Skip_Image_X_Right_Pos = 224;
    private static final byte _Blinking1_ = 0;
    private static final byte _Growing1_ = 1;
    private static final byte _Blinking2_ = 2;
    private static final byte _Growing2_ = 3;
    private static final byte _Speaking_ = 4;
    private static final int _Face_X_Pos_ = 12;
    private static final int _Face_Y_Pos_ = 13;
    public static final int[] _Rect0_ = new int[]{8, 9, 223, 99};
    public static final int[] _Rect1_ = new int[]{4, 4, 2, 109};
    public static final int[] _Rect2_ = new int[]{6, 4, 226, 3};
    public static final int[] _Rect3_ = new int[]{233, 4, 2, 109};
    public static final int[] _Rect4_ = new int[]{6, 110, 226, 3};
    private static final int[] _Text_ = new int[]{84, 23, 140, 89};
    private static final int[] _TF_WC = new int[]{4, 4, 226, 109};
    private static final int _City_X_Pos_ = 3;
    private static final int _City_Y_Pos_ = 116;
    private static final int[] _CF_WC = new int[]{3, 116, 224, 302};
    public static final short _MenuType_NOMENU_ = -2;
    public static final short _MenuType_LOGOMENU_ = -1;
    public static final short _MenuType_MAINMENU_ = 0;
    public static final short _MenuType_OPTIONSMENU_ = 1;
    public static final short _MenuType_VIEWRECORDSMENU_ = 2;
    public static final short _MenuType_INSERTRECORDSMENU_ = 3;
    public static final short _MenuType_HELPMENU_ = 4;
    public static final short _MenuType_GAMEMENU_ = 5;
    public static final short _MenuType_MISSIONMENU_ = 6;
    public static final short _MenuType_RESULTMENU_ = 7;
    public static final short _MenuType_ENDINGMENU_ = 8;
    public static final short _MenuType_CREDITSMENU_ = 9;
    public static final short _MenuType_SOUNDMENU_ = 10;
    public static final short _MenuType_LANGUAGEMENU_ = 11;
    public static final short _MenuType_ENABLESOUNDMENU_ = 12;
    public static final short _MenuType_LOADMENU_ = 13;
    public static final short _MenuType_WARNINGMENU_ = 14;
    public static final short _MenuType_STAGE_MENU_ = 15;
    public static final short _MenuType_MODE_MENU_ = 16;
    public static final short _MenuType_BAD_ENDING_ = 17;
    public static final short _MenuType_GOOD_ENDING_ = 18;
    public static final short _MenuType_PASSWORD_MENU_ = 19;
    public static final short _MenuType_LANGUAGEMENU_2_ = 20;
    public static final short _MenuType_OTHERSMENU_ = 21;
    public static final byte _FirstValid_MenuLogo_Phase = 0;
    public static final byte _MenuLogo_Phase_0 = 0;
    public static final byte _MenuLogo_Phase_1 = 1;
    public static final byte _MenuLogo_Phase_2 = 2;
    public static final byte _MenuLogo_Phase_3 = 3;
    public static final byte _LastValid_MenuLogo_Phase = 3;
    public static final short _MenuCursor_W_ = 9;
    public static final short _MenuCursor_H_ = 9;
    public static final short _MAXOFFSET_ = 10;
    public static final short _SPEEDFACTOR_ = 1;
    public static final byte _FadeIn_TURN_ = -2;
    public static final byte _Chopter_TURN_ = -1;
    public static final byte _Police_Chief_TURN_ = 0;
    public static final byte _Sniper_TURN_ = 1;
    public static final byte _FadeOut_TURN_ = 2;
    public static final byte _Scrolling_TURN_ = 3;
    public static final byte _Cheat_TURN_ = 4;
    public static final long _Time_TURN_ = 5000L;
    public static final int SLEEP_TIME = 50;
    public static final long LOGO_DURATION = 3000L;
    public static final long HALF_LOGO_DURATION = 1500L;
    public static final long TIME_TO_INIT_DEMO_MODE = 5000L;
    public static final int _Options_InitX_ = 136;
    public static final int _Options_InitY_ = 204;
    public static final int _Options_GapX = -5;
    public static final int _Options_GapY = 16;
    public static final int SCROLL_AREA_HEIGHT = 75;
    public static final int CREDITSIMAGE_H = 500;
    public static final int CLIPY = 122;
    public static final int _Init_Scroll_Pos_ = 197;
    public static final int Game_Over_Time = 6000;
    public static final int Init_Value = 30;
    public static final int Final_Value = 31;
    public static final int BUILDING_X_POS = 0;
    public static final int BUILDING_FINAL_Y_POS = 201;
    public static final int BUILDING_INIT_Y_POS = 320;
    public static final int[][] HELICOPTER_WAYPOINTS = new int[][]{{-67, 165}, {-9, 185}, {6, 205}};
    public static final int SUN_X_POS = 88;
    public static final int SUN_Y_POS = 179;
    public static final int ENDING_BACKGROUND_COLOR = -3635934;
    public static final int POLICE_CHIEF_FRAME_X_POS = 4;
    public static final int POLICE_CHIEF_FRAME_Y_POS = 5;
    public static final int SNIPER_FRAME_X_POS = 4;
    public static final int SNIPER_FRAME_Y_POS = 132;
    public static final int SNIPER_FACE_X_OFFSET = 147;
    public static final int SNIPER_FACE_Y_OFFSET = 8;
    public static final long TIME_TO_WAYPOINT = 5000L;
    private SniperMIDlet gameMidlet;
    private boolean running;
    private boolean menuReady;
    private boolean firstTime;
    private boolean skipMenu;
    private boolean left = false;
    private boolean right = true;
    private int offset = 0;
    private int volumen;
    private boolean optionsMenu;
    private int optionsMenuState;
    private long toptionsMenu;
    private float optionsCoef;
    private short nextMenu;
    private short nextMode;
    private String attrib;
    private String attribVal;
    private int unlockCheatIndex;
    private byte menuLogoPhase;
    private int counter = 0;
    private int blink = 0;
    private Vector vsOptions;
    private Vector vsSelectedOptions;
    private short menuType;
    private short optionsNumber;
    private short optionSelected;
    private long initLogoTime;
    private long initDemoTime;
    private int xLogo;
    private int yLogo;
    private int xBack;
    private int yBack;
    private int xOk;
    private int yOk;
    private int xTitle;
    private int yTitle;
    private int titleFadeW;
    private int titleFadeH;
    private String missionInfo;
    private byte briefingState;
    private int visibleFlag;
    private int line;
    private int wc1X;
    private int wc2X;
    private int wc1Y;
    private int wc2Y;
    private long initStateTime;
    private int actualPage;
    private int level;
    private int scrollY;
    private int categoryImageIndex;
    private int clipBrdX;
    private int clipBrdY;
    private int clipBrdW;
    private int clipBrdH;
    private String categories;
    private String categoryValues;
    private String title;
    private int lettersPerRow;
    private int rowsNumber;
    private int cellW;
    private int cellH;
    private int xInsertRecordImage;
    private int yInsertRecordImage;
    private int xCursor;
    private int yCursor;
    private int maxX;
    private int maxY;
    private boolean accept;
    private String password;
    private long initMessageTime;
    private boolean renderMessage;
    private String messageToRender;
    private int helicopterXPos;
    private int helicopterYPos;
    private int cityYPos;
    private long helicopterTime;
    private int actualWaypoint;
    private int nextWaypoint;
    private int yInit;
    private int yFinal;
    private byte turn;
    private long tInitTurn;
    private int drawingY;
    private Image iMenuBackground;
    private Image iLogo;
    private Image iCMCCLogo;
    private Image iMOLogo;
    private Image iSkip;
    private Image iMenuCursor;
    private Image[] iStageMapsSmall;
    private Image[] iStageMapsBig;
    private Image iFace;
    private Image iClipBoard;
    private Image iCementery;
    private Image iFadeOutLogo;
    private Image iInsertRecord;
    private Image iIconBack;
    private Image iIconAccept;
    private Image[] iFlags;
    private Image iWindowCorner;
    private Image iGrades;
    private Image iWarningFrame;
    private Image iSniperFace;
    private Image iHelicopter;
    private Image iBuilding;
    private Image iBlades;
    private Image iSun;
    private Image iMark;
    private SpriteObject grades;
    private SpriteObject helicopterBlades;
    private boolean upPressed;
    private boolean downPressed;
    private boolean leftPressed;
    private boolean rightPressed;
    final int SubPageCharCount;
    private int actualSubPage;
    public static final int[][] cityOffsets = new int[][]{{39, 56}, {57, 52}, {43, 74}, {61, 70}};
    private int helpTextScroll;

    public MenuCanvas(SniperMIDlet midlet) {
        this.SubPageCharCount = 27;
        this.gameMidlet = midlet;
        this.setFullScreenMode(true);
        this.running = false;
    }

    private final void moveToRight() {
        this.xCursor += 2;
        if (this.xCursor + 4 >= this.maxX) {
            this.xCursor = this.maxX - 4;
        }
    }

    private final void moveToLeft() {
        this.xCursor -= 2;
        if (this.xCursor - 4 <= this.xInsertRecordImage) {
            this.xCursor = this.xInsertRecordImage + 4;
        }
    }

    private final void moveToUp() {
        this.yCursor -= 2;
        if (this.yCursor - 4 <= this.yInsertRecordImage) {
            this.yCursor = this.yInsertRecordImage + 4;
        }
    }

    private final void moveToDown() {
        this.yCursor += 2;
        if (this.yCursor + 4 >= this.maxY) {
            this.yCursor = this.maxY - 4;
        }
    }

    private final void updateAttribVal() {
        switch (this.menuType) {
            case 15: {
                String status = this.optionSelected < SniperMIDlet.getUnlockStages() ? Resources.getString(81) : Resources.getString(82);
                this.attribVal = "0" + (this.optionSelected + 1) + "\n" + status;
                break;
            }
            case 2: {
                String previousStageRecord = SniperMIDlet.load("sniperOpsRecordStage" + this.optionSelected);
                if (previousStageRecord.equals("")) {
                    this.buildAttribVal(this.optionSelected + 1, 0, 0.0f);
                    break;
                }
                try {
                    PWTokenizer tok = new PWTokenizer(previousStageRecord, '#');
                    int prevPoints = Integer.parseInt(tok.nextToken());
                    float prevAccuracy = Float.parseFloat(tok.nextToken());
                    this.buildAttribVal(this.optionSelected + 1, prevPoints, prevAccuracy);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final void hideNotify() {
        Input.InitKey();
        this.gameMidlet.soundEngine.stopMainTheme();
    }

    public final void showNotify() {
    }

    private final void buildAttribVal(int stage, int points, float accuracy) {
        if (accuracy == 100.0f) {
            String category = "A";
        } else if (accuracy < 100.0f && accuracy >= 80.0f) {
            String category = "B";
        } else if (accuracy < 80.0f && accuracy >= 60.0f) {
            String category = "C";
        } else if (accuracy < 60.0f && accuracy >= 50.0f) {
            String category = "D";
        } else if (accuracy < 50.0f && accuracy > 0.0f) {
            String category = "F";
        } else {
            String category = Resources.getString(83);
        }
        this.attribVal = "0" + stage + "\n" + points + "\n" + (int)accuracy;
    }

    private final void buildInsertRecordMenuImage() {
        this.lettersPerRow = 8;
        this.rowsNumber = 4;
        this.cellW = 16;
        this.cellH = 16;
        int h = this.cellH * this.rowsNumber;
        int w = this.cellW * this.lettersPerRow;
        this.iInsertRecord = Image.createImage((int)w, (int)h);
        this.iInsertRecord.getGraphics().setColor(-16777216);
        this.iInsertRecord.getGraphics().fillRect(0, 0, w, h);
        for (int i = 0; i < this.rowsNumber; ++i) {
            block5: for (int j = 0; j < this.lettersPerRow; ++j) {
                char letter = (char)(i * this.lettersPerRow + j + 65);
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        SniperMIDlet.gameFont.drawString(this.iInsertRecord.getGraphics(), String.valueOf(letter), j * this.cellW, i * this.cellH, this.cellW, this.cellH, 3);
                        continue block5;
                    }
                    case 3: {
                        if (j != 3 && j != 4) continue block5;
                        letter = (char)(i * this.lettersPerRow + (j - 3) + 65);
                        SniperMIDlet.gameFont.drawString(this.iInsertRecord.getGraphics(), String.valueOf(letter), j * this.cellW, i * this.cellH, this.cellW, this.cellH, 3);
                    }
                }
            }
        }
        SniperMIDlet.gameFont.drawString(this.iInsertRecord.getGraphics(), Resources.getString(65), 0, 3 * this.cellH, this.cellW * 3, this.cellH, 3);
        SniperMIDlet.gameFont.drawString(this.iInsertRecord.getGraphics(), Resources.getString(38), 5 * this.cellW, 3 * this.cellH, this.cellW * 3, this.cellH, 3);
        this.xInsertRecordImage = (240 - w) / 2;
        this.yInsertRecordImage = (320 - h) / 2;
        this.xCursor = this.xInsertRecordImage + w / 2;
        this.yCursor = this.yInsertRecordImage + h / 2;
        this.maxX = this.xInsertRecordImage + w;
        this.maxY = this.yInsertRecordImage + h;
    }

    private final void buildFadeOutImage(int w, int h, int alpha) {
        int[] temp = new int[w * h];
        int color = (alpha <<= 24) | 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                temp[i * w + j] = color;
            }
        }
        this.iFadeOutLogo = Image.createRGBImage((int[])temp, (int)w, (int)h, (boolean)true);
    }

    private final void processBriefingState() {
        long actualT = System.currentTimeMillis();
        long elapsedT = actualT - this.initStateTime;
        switch (this.briefingState) {
            case 0: {
                if (elapsedT > 700L) {
                    this.initStateTime = actualT;
                    this.briefingState = 1;
                    break;
                }
                this.visibleFlag = (this.visibleFlag + 1) % 2;
                this.wc1X = MenuCanvas.toPixelX(2);
                this.wc1Y = MenuCanvas.toPixelY(4);
                break;
            }
            case 1: {
                if (elapsedT > 700L) {
                    this.initStateTime = actualT;
                    this.briefingState = (byte)2;
                    this.wc2X = MenuCanvas.toPixelX(2);
                    this.wc2Y = MenuCanvas.toPixelY(35);
                    this.wc1X = MenuCanvas.toPixelX(2) + MenuCanvas.toPixelX(96);
                    this.wc1Y = MenuCanvas.toPixelY(4) + MenuCanvas.toPixelY(26);
                    break;
                }
                float coef = (float)elapsedT * 1.0f / 700.0f;
                this.wc1X = Math3D.linearInterpolation(_TF_WC[0], _TF_WC[2], coef);
                this.wc1Y = Math3D.linearInterpolation(_TF_WC[1], _TF_WC[3], coef);
                break;
            }
            case 2: {
                if (elapsedT > 700L) {
                    this.initStateTime = actualT;
                    this.briefingState = (byte)3;
                    this.wc2X = MenuCanvas.toPixelX(2);
                    this.wc2Y = MenuCanvas.toPixelY(35);
                    break;
                }
                this.visibleFlag = (this.visibleFlag + 1) % 2;
                break;
            }
            case 3: {
                if (elapsedT > 700L) {
                    this.actualPage = 0;
                    this.actualSubPage = 0;
                    this.missionInfo = Resources.getString(Resources.Mission_Init_Phrases[this.level] + this.actualPage);
                    SniperMIDlet.gameFont.setWritingSpeed(40);
                    this.resetDymanicFont();
                    this.briefingState = (byte)4;
                    this.wc2X = _CF_WC[0] + _CF_WC[2];
                    this.wc2Y = _CF_WC[1] + _CF_WC[3];
                    break;
                }
                float coef = (float)elapsedT * 1.0f / 700.0f;
                this.wc2X = Math3D.linearInterpolation(_CF_WC[0], _CF_WC[2], coef);
                this.wc2Y = Math3D.linearInterpolation(_CF_WC[1], _CF_WC[3], coef);
                break;
            }
        }
    }

    public final void unloadMenuResources() {
        int i;
        this.iMenuBackground = null;
        this.iLogo = null;
        this.iCMCCLogo = null;
        this.iMOLogo = null;
        this.iMenuCursor = null;
        this.iFace = null;
        if (this.iStageMapsSmall != null) {
            for (i = 0; i < this.iStageMapsSmall.length; ++i) {
                this.iStageMapsSmall[i] = null;
            }
        }
        this.iStageMapsSmall = null;
        if (this.iStageMapsBig != null) {
            for (i = 0; i < this.iStageMapsBig.length; ++i) {
                this.iStageMapsBig[i] = null;
            }
            this.iStageMapsBig = null;
        }
        this.iFadeOutLogo = null;
        this.iCementery = null;
        this.iClipBoard = null;
        this.iIconBack = null;
        this.iIconAccept = null;
        this.iWindowCorner = null;
        this.iSkip = null;
        this.iGrades = null;
        this.grades = null;
        this.iSun = null;
        this.iHelicopter = null;
        this.iSniperFace = null;
        this.iBuilding = null;
        this.iBlades = null;
        this.helicopterBlades = null;
        this.title = null;
        this.categories = null;
        this.categoryValues = null;
        this.missionInfo = null;
        this.password = null;
        this.messageToRender = null;
        this.attrib = null;
        this.attribVal = null;
        this.vsOptions = null;
        this.vsSelectedOptions = null;
        SniperMIDlet.cleanMemory();
    }

    private final void generateMissionReportStrings() {
        int accuracy = (int)GameEngine.getAccuracy();
        this.title = Resources.getString(17);
        this.categories = Resources.getString(19) + "\n" + Resources.getString(20) + "\n" + Resources.getString(21) + "\n" + Resources.getString(18) + "\n" + Resources.getString(22);
        this.categoryImageIndex = (float)accuracy == 100.0f ? 0 : ((float)accuracy < 100.0f && (float)accuracy >= 80.0f ? 1 : ((float)accuracy < 80.0f && (float)accuracy >= 60.0f ? 2 : ((float)accuracy < 60.0f && (float)accuracy >= 50.0f ? 3 : 4)));
        this.categoryValues = "" + GameEngine.getGoodShots() + "\n" + GameEngine.getBadShots() + "\n" + GameEngine.getHeadShots() + "\n" + accuracy + "\n" + " ";
    }

    public final void updatePageToShow() {
        this.updatePageToShow2();
    }

    private String makeMissionInfo(String info, int subPage) {
        String str = "";
        str = info.length() < (subPage + 1) * 27 ? info.substring(subPage * 27) : info.substring(subPage * 27, subPage * 27 + 27);
        return str;
    }

    private void updatePageToShow2() {
        String pageStr = Resources.getString(Resources.Mission_Init_Phrases[this.level] + this.actualPage);
        int subPageCount = pageStr.length() / 27;
        if (pageStr.length() % 27 != 0) {
            ++subPageCount;
        }
        ++this.actualSubPage;
        if (this.actualSubPage >= subPageCount) {
            this.actualSubPage = 0;
            ++this.actualPage;
            if (this.actualPage >= Resources.Mission_History_Size[this.level]) {
                this.setNextState((short)1);
            } else {
                this.missionInfo = this.makeMissionInfo(Resources.getString(Resources.Mission_Init_Phrases[this.level] + this.actualPage), this.actualSubPage);
                this.resetDymanicFont();
            }
        } else {
            this.missionInfo = this.makeMissionInfo(Resources.getString(Resources.Mission_Init_Phrases[this.level] + this.actualPage), this.actualSubPage);
            this.resetDymanicFont();
        }
    }

    private final void resetMenuAttributes() {
        this.optionSelected = 0;
        this.menuReady = false;
        this.optionsMenu = false;
        this.skipMenu = false;
        this.running = false;
        this.firstTime = true;
        this.accept = false;
        this.upPressed = false;
        this.downPressed = false;
        this.leftPressed = false;
        this.rightPressed = false;
        this.vsOptions = new Vector();
        this.vsSelectedOptions = new Vector();
    }

    public final void initMenu(short menu) {
        Console.output("initMenu() : " + menu);
        this.resetMenuAttributes();
        this.menuType = menu;
        this.loadCommonMenuResources();
        this.loadSpecificMenuResources();
        switch (this.menuType) {
            case 11: 
            case 20: {
                this.optionsNumber = (short)5;
                break;
            }
            case 17: {
                this.turn = (byte)-2;
                this.tInitTurn = System.currentTimeMillis();
                this.optionsNumber = 0;
                this.drawingY = 30;
                this.buildFadeOutImage(240, 260, 255);
                break;
            }
            case 18: {
                this.turn = (byte)-2;
                this.tInitTurn = System.currentTimeMillis();
                this.optionsNumber = 0;
                this.buildFadeOutImage(240, 260, 255);
                break;
            }
            case 16: {
                this.addOption(Resources.getString(14));
                this.addOption(Resources.getString(15));
                this.optionsNumber = (short)2;
                this.optionsMenu = true;
                break;
            }
            case 12: {
                this.optionsNumber = 0;
                break;
            }
            case -1: {
                this.optionsNumber = 0;
                this.initLogoTime = System.currentTimeMillis();
                break;
            }
            case 14: {
                this.optionsNumber = 0;
                break;
            }
            case 0: {
                this.resetInitDemoTime();
                this.addOption(Resources.getString(0));
                this.addOption(Resources.getString(2));
                this.addOption(Resources.getString(1));
                this.addOption(Resources.getString(86));
                this.addOption(Resources.getString(7));
                this.addOption(Resources.getString(3));
                this.optionsNumber = (short)6;
                this.optionsMenu = true;
                break;
            }
            case 21: {
                this.addOption(Resources.getString(8));
                this.addOption(Resources.getString(9));
                this.optionsNumber = (short)2;
                this.optionsMenu = true;
                break;
            }
            case 15: {
                this.attrib = Resources.getString(16) + "\n" + Resources.getString(84);
                this.updateAttribVal();
                this.optionsNumber = (short)4;
                this.optionsMenu = true;
                break;
            }
            case 13: {
                this.addOption(Resources.getString(4));
                this.addOption(Resources.getString(5));
                this.optionsMenu = true;
                this.optionsNumber = (short)2;
                break;
            }
            case 1: {
                this.addOption(Resources.getString(6));
                this.optionsNumber = 1;
                this.optionsMenu = true;
                break;
            }
            case 2: {
                this.attrib = Resources.getString(16) + "\n" + Resources.getString(85) + "\n" + Resources.getString(18);
                this.updateAttribVal();
                this.optionsNumber = (short)4;
                break;
            }
            case 4: {
                this.optionsNumber = 0;
                break;
            }
            case 19: {
                this.optionsNumber = 0;
                this.password = "";
                break;
            }
            case 5: {
                this.optionsNumber = 0;
                break;
            }
            case 6: {
                this.briefingState = 0;
                this.visibleFlag = 0;
                this.line = 0;
                this.initStateTime = System.currentTimeMillis();
                this.wc1X = MenuCanvas.toPixelX(2);
                this.wc1Y = MenuCanvas.toPixelY(4);
                this.optionsNumber = 0;
                this.level = SniperMIDlet.getStageToLoad();
                this.optionSelected = (short)this.level;
                this.actualPage = 0;
                this.actualSubPage = 0;
                this.missionInfo = Resources.getString(Resources.Mission_Init_Phrases[this.level] + this.actualPage);
                SniperMIDlet.gameFont.setWritingSpeed(40);
                this.resetDymanicFont();
                break;
            }
            case 7: {
                this.generateMissionReportStrings();
                break;
            }
            case 9: {
                this.optionsNumber = 0;
                break;
            }
            case 10: {
                this.volumen = this.gameMidlet.soundEngine.getCurrentVolumen() / 10;
                if (this.gameMidlet.soundEngine.isMusicEnable()) {
                    this.addOption(Resources.getString(10));
                } else {
                    this.addOption(Resources.getString(11));
                }
                this.addOption(Resources.getString(66));
                this.optionsNumber = (short)2;
                this.optionsMenu = true;
            }
        }
        if (this.optionsMenu) {
            this.toptionsMenu = System.currentTimeMillis();
            this.optionsMenuState = 0;
        }
        this.menuReady = true;
    }

    private final void resetDymanicFont() {
        SniperMIDlet.gameFont.setTextToRender(this.missionInfo, _Text_[0], _Text_[1], _Text_[2], _Text_[3], 20);
        SniperMIDlet.gameFont.setInitTime(System.currentTimeMillis());
    }

    public final short getMenuType() {
        return this.menuType;
    }

    public final void loadCommonMenuResources() {
        this.iIconBack = Resources.loadImage("/x/iconBack.png");
        this.xBack = 240 - this.iIconBack.getWidth() - 2;
        this.yBack = 320 - this.iIconBack.getHeight() - 2;
        this.iIconAccept = Resources.loadImage("/x/iconAccept.png");
        this.xOk = 2;
        this.yOk = this.yBack;
    }

    public final void loadSpecificMenuResources() {
        switch (this.menuType) {
            case 11: 
            case 20: {
                this.iFlags = new Image[5];
                for (int i = 0; i < 5; ++i) {
                    this.iFlags[i] = Resources.loadImage("/x/flag" + i + ".png");
                }
                break;
            }
            case -1: {
                this.iLogo = Resources.loadImage("/x/zed.png");
                this.iCMCCLogo = Resources.loadImage("/x/cmcc.png");
                this.iMOLogo = Resources.loadImage("/x/mo.png");
                this.buildFadeOutImage(240, 320, 0);
                this.xLogo = (240 - this.iLogo.getWidth()) / 2;
                this.yLogo = (320 - this.iLogo.getHeight()) / 2;
                this.xTitle = (240 - this.titleFadeW) / 2;
                this.yTitle = (320 - this.titleFadeH) / 2;
                break;
            }
            case 0: 
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                this.iMenuBackground = Resources.loadImage("/x/menuImage.png");
                this.iMenuCursor = Resources.loadImage("/x/menuCursor.png");
                if (this.iMenuBackground == null) {
                    // empty if block
                }
                if (this.menuType != 14) break;
                this.iWarningFrame = Resources.loadImage("/x/messageFrame.png");
                break;
            }
            case 17: {
                this.iCementery = Resources.loadImage("/x/cementery.png");
                break;
            }
            case 18: {
                this.iSun = Resources.loadImage("/x/sun.png");
                this.iHelicopter = Resources.loadImage("/x/helicopter.png");
                this.iSniperFace = Resources.loadImage("/x/sniperFace.png");
                this.iBuilding = Resources.loadImage("/x/buildings.png");
                this.iBlades = Resources.loadImage("/x/blades.png");
                this.iFace = Resources.loadImage("/x/cop.png");
                this.helicopterBlades = new SpriteObject(this.iBlades);
                this.helicopterBlades.initHelicopterBlades();
                break;
            }
            case 4: {
                break;
            }
            case 3: 
            case 19: {
                this.iMenuCursor = Resources.loadImage("/x/menuCursor.png");
                this.buildInsertRecordMenuImage();
                break;
            }
            case 2: 
            case 6: 
            case 15: {
                int i;
                this.iWindowCorner = Resources.loadImage("/x/windowcorner.png");
                this.iFace = Resources.loadImage("/x/cop.png");
                this.iStageMapsSmall = new Image[4];
                for (i = 0; i < 4; ++i) {
                    this.iStageMapsSmall[i] = Resources.loadImage("/x/stage_" + (i + 1) + "_s.png");
                }
                this.iStageMapsBig = new Image[4];
                for (i = 0; i < 4; ++i) {
                    this.iStageMapsBig[i] = Resources.loadImage("/x/stage_" + (i + 1) + ".png");
                }
                this.iSkip = Resources.loadImage("/x/skip.png");
                break;
            }
            case 7: {
                this.iClipBoard = Resources.loadImage("/x/clipboard.png");
                this.clipBrdW = this.iClipBoard.getWidth();
                this.clipBrdH = this.iClipBoard.getHeight();
                this.clipBrdX = (240 - this.clipBrdW) / 2;
                this.clipBrdY = (320 - this.clipBrdH) / 2;
                this.iGrades = Resources.loadImage("/x/grades.png");
                this.iSkip = Resources.loadImage("/x/skip.png");
                this.grades = new SpriteObject(this.iGrades);
                this.grades.initGrades();
                break;
            }
        }
    }

    public final int addOption(String sOption) {
        return this.addOption(sOption, sOption);
    }

    public int addOption(String sOption, String sSelectedOption) {
        this.vsOptions.addElement(sOption);
        this.vsSelectedOptions.addElement(sSelectedOption);
        return this.vsOptions.size() - 1;
    }

    protected final void keyPressed(int keyCode) {
        Input.keyPressed(keyCode);
        if (this.running && this.menuReady) {
            this.processKey(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        Input.keyReleased(keyCode);
        int gameAction = -1000;
        if (keyCode == 50 || gameAction == 1 || keyCode == -1) {
            this.upPressed = false;
        } else if (keyCode == 56 || gameAction == 6 || keyCode == -2) {
            this.downPressed = false;
        } else if (keyCode == 52 || gameAction == 2 || keyCode == -3) {
            this.leftPressed = false;
        } else if (keyCode == 54 || gameAction == 5 || keyCode == -4) {
            this.rightPressed = false;
        }
    }

    private final void processKey(int keyCode) {
        int gameAction = -1000;
        this.resetInitDemoTime();
        if (keyCode == 50 || gameAction == 1 || keyCode == -1) {
            this.processUpKey();
        } else if (keyCode == 56 || gameAction == 6 || keyCode == -2) {
            this.processDownKey();
        } else if (keyCode == 52 || gameAction == 2 || keyCode == -3) {
            this.processLeftKey();
        } else if (keyCode == 54 || gameAction == 5 || keyCode == -4) {
            this.processRightKey();
        } else if (keyCode == 53 || gameAction == 8 || keyCode == -5) {
            this.processAcceptKey();
        }
    }

    private final void processLeftSoftButton() {
        switch (this.menuType) {
            case 0: 
            case 1: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.processAcceptKey();
                break;
            }
            case 6: {
                this.processLeftKey();
                break;
            }
            case 21: {
                if (this.optionsMenuState != 1) {
                    return;
                }
                switch (this.optionSelected) {
                    case 0: {
                        this.nextMode = 0;
                        this.nextMenu = (short)2;
                        break;
                    }
                    case 1: {
                        this.nextMode = 0;
                        this.nextMenu = (short)19;
                        break;
                    }
                    case 2: {
                        this.nextMode = (short)2;
                        this.nextMenu = (short)-2;
                    }
                }
                break;
            }
            case 4: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 12: {
                this.gameMidlet.soundEngine.enableMusic();
                this.setNextState((short)0);
                this.setNextMenu((short)-1);
            }
        }
        if (this.optionsMenu) {
            this.toptionsMenu = System.currentTimeMillis();
            this.optionsMenuState = 2;
        }
    }

    private final void processRightSoftButton() {
        switch (this.menuType) {
            case 0: {
                break;
            }
            case 6: {
                this.processRightKey();
                break;
            }
            case 2: {
                this.setNextState((short)0);
                this.setNextMenu((short)21);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 21: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 15: {
                this.setNextState((short)0);
                this.setNextMenu((short)16);
                break;
            }
            case 20: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 10: {
                SniperMIDlet.saveCurrentSoundLevel(this.volumen * 10);
                this.setNextState((short)0);
                this.setNextMenu((short)1);
                break;
            }
            case 19: {
                this.setNextState((short)0);
                this.setNextMenu((short)21);
                break;
            }
            case 7: {
                this.processAcceptKey();
                break;
            }
            case 9: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 12: {
                this.gameMidlet.soundEngine.disableMusic();
                this.setNextState((short)0);
                this.setNextMenu((short)-1);
                break;
            }
            case 14: {
                this.setNextState((short)0);
                this.setNextMenu((short)13);
                break;
            }
            case 13: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
            }
        }
    }

    private final void processUpKey() {
        this.upPressed = true;
        switch (this.menuType) {
            case 4: {
                if (++this.helpTextScroll <= 0) break;
                this.helpTextScroll = 0;
                break;
            }
            case 9: {
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                this.skipMenu = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                this.optionSelected = (short)(this.optionSelected - 1);
                if (this.optionSelected < 0) {
                    this.optionSelected = (short)(this.optionsNumber - 1);
                }
                if (this.menuType != 2 && this.menuType != 15) break;
                this.updateAttribVal();
            }
        }
    }

    private final void reduceVolume() {
        this.volumen = this.volumen <= 0 ? 0 : --this.volumen;
        this.gameMidlet.soundEngine.updateVolumen(this.volumen * 10);
    }

    private final void riseVolume() {
        this.volumen = this.volumen >= 10 ? 10 : ++this.volumen;
        this.gameMidlet.soundEngine.updateVolumen(this.volumen * 10);
    }

    private final void processDownKey() {
        this.downPressed = true;
        switch (this.menuType) {
            case 4: {
                if (--this.helpTextScroll >= -68) break;
                this.helpTextScroll = -68;
                break;
            }
            case 9: {
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                this.skipMenu = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                this.optionSelected = (short)(this.optionSelected + 1);
                if (this.optionSelected >= this.optionsNumber) {
                    this.optionSelected = 0;
                }
                if (this.menuType != 2 && this.menuType != 15) break;
                this.updateAttribVal();
            }
        }
    }

    private final void processLeftKey() {
        this.leftPressed = true;
        switch (this.menuType) {
            case 9: {
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                this.skipMenu = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                this.optionSelected = (short)(this.optionSelected - 1);
                if (this.optionSelected < 0) {
                    this.optionSelected = (short)(this.optionsNumber - 1);
                }
                if (this.menuType != 2 && this.menuType != 15) break;
                this.updateAttribVal();
                break;
            }
            case 10: {
                if (this.optionSelected != 1) break;
                this.reduceVolume();
                break;
            }
            case 6: {
                this.setNextState((short)1);
            }
        }
    }

    private final String buildTheString(int column, int row, String aString) {
        block13: {
            switch (row) {
                case 0: 
                case 1: 
                case 2: {
                    int offset = row * 8 + column;
                    if (aString.length() >= 10) break;
                    return aString + String.valueOf((char)(65 + offset));
                }
                case 3: {
                    switch (column) {
                        case 0: 
                        case 1: 
                        case 2: {
                            int size = aString.length();
                            if (size > 0) {
                                return aString.substring(0, --size);
                            }
                            break block13;
                        }
                        case 3: {
                            int offset = row * 8 + 0;
                            if (aString.length() < 10) {
                                return aString + String.valueOf((char)(65 + offset));
                            }
                            break block13;
                        }
                        case 4: {
                            int offset = row * 8 + 1;
                            if (aString.length() < 10) {
                                return aString + String.valueOf((char)(65 + offset));
                            }
                            break block13;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            this.accept = true;
                        }
                    }
                }
            }
        }
        return aString;
    }

    private final void processRightKey() {
        this.rightPressed = true;
        switch (this.menuType) {
            case -1: {
                this.skipMenu = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                this.optionSelected = (short)(this.optionSelected - 1);
                if (this.optionSelected < 0) {
                    this.optionSelected = (short)(this.optionsNumber - 1);
                }
                if (this.menuType != 2 && this.menuType != 15) break;
                this.updateAttribVal();
                break;
            }
            case 10: {
                if (this.optionSelected != 1) break;
                this.riseVolume();
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                this.updatePageToShow();
            }
        }
    }

    private final void verifyPassword() {
        if (this.password.equals(CHEATS[0])) {
            SniperMIDlet.godMode = true;
            this.initMessageTime = System.currentTimeMillis();
            this.messageToRender = Resources.getString(24);
            this.renderMessage = true;
        } else if (this.password.equals(CHEATS[1])) {
            SniperMIDlet.specialBullets = true;
            this.initMessageTime = System.currentTimeMillis();
            this.messageToRender = Resources.getString(24);
            this.renderMessage = true;
        } else if (this.password.equals(CHEATS[2])) {
            SniperMIDlet.specialBullets = true;
            SniperMIDlet.godMode = true;
            SniperMIDlet.unlimitedAmmo = true;
            this.initMessageTime = System.currentTimeMillis();
            this.messageToRender = Resources.getString(24);
            this.renderMessage = true;
        } else {
            this.initMessageTime = System.currentTimeMillis();
            this.renderMessage = true;
            this.messageToRender = Resources.getString(25);
            this.password = "";
        }
    }

    private final void processAcceptKey() {
        block0 : switch (this.menuType) {
            case -1: {
                this.skipMenu = true;
                break;
            }
            case 17: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 18: {
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 21: {
                if (this.optionsMenuState != 1) {
                    return;
                }
                switch (this.optionSelected) {
                    case 0: {
                        this.nextMode = 0;
                        this.nextMenu = (short)2;
                        break;
                    }
                    case 1: {
                        this.nextMode = 0;
                        this.nextMenu = (short)19;
                        break;
                    }
                    case 2: {
                        this.nextMode = (short)2;
                        this.nextMenu = (short)-2;
                    }
                }
                break;
            }
            case 16: {
                if (this.optionsMenuState != 1) {
                    return;
                }
                switch (this.optionSelected) {
                    case 0: {
                        SniperMIDlet.loadLastGame();
                        if (SniperMIDlet.previousSavedGame) {
                            this.nextMode = 0;
                            this.nextMenu = (short)13;
                        } else {
                            SniperMIDlet.setStageToLoad(0);
                            SniperMIDlet.updatePlayerLife(100);
                            SniperMIDlet.updatePlayerPoints(0);
                            this.nextMode = 0;
                            this.nextMenu = (short)6;
                        }
                        SniperMIDlet.playingArcadeMode = true;
                        break;
                    }
                    case 1: {
                        SniperMIDlet.playingArcadeMode = false;
                        this.nextMode = 0;
                        this.nextMenu = (short)15;
                    }
                }
                break;
            }
            case 11: {
                Resources.loadLangData("/x/" + Resources.LANGS[this.optionSelected]);
                for (int i = 0; i < Resources.lang.length; ++i) {
                    Resources.lang[i] = Resources.replace(Resources.lang[i], "\\N", "\n");
                }
                SniperMIDlet.setLanguage(this.optionSelected);
                SniperMIDlet.saveLanguage();
                this.setNextState((short)0);
                this.setNextMenu((short)12);
                break;
            }
            case 20: {
                Resources.loadLangData("/x/" + Resources.LANGS[this.optionSelected]);
                for (int i = 0; i < Resources.lang.length; ++i) {
                    Resources.lang[i] = Resources.replace(Resources.lang[i], "\\N", "\n");
                }
                SniperMIDlet.setLanguage(this.optionSelected);
                SniperMIDlet.saveLanguage();
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 12: {
                this.gameMidlet.soundEngine.enableMusic();
                this.setNextState((short)0);
                this.setNextMenu((short)-1);
                break;
            }
            case 19: {
                int column = (this.xCursor - this.xInsertRecordImage) / this.cellW;
                int row = (this.yCursor - this.yInsertRecordImage) / this.cellH;
                this.password = this.buildTheString(column, row, this.password);
                if (!this.accept) break;
                this.verifyPassword();
                this.accept = false;
                break;
            }
            case 13: {
                switch (this.optionSelected) {
                    case 0: {
                        this.nextMode = 0;
                        this.nextMenu = (short)6;
                        break;
                    }
                    case 1: {
                        this.nextMode = 0;
                        this.nextMenu = (short)14;
                    }
                }
                break;
            }
            case 14: {
                SniperMIDlet.setStageToLoad(0);
                SniperMIDlet.updatePlayerLife(100);
                SniperMIDlet.updatePlayerPoints(0);
                this.setNextState((short)0);
                this.setNextMenu((short)6);
                break;
            }
            case 0: {
                if (this.optionsMenuState != 1) {
                    return;
                }
                switch (this.optionSelected) {
                    case 0: {
                        this.nextMode = 0;
                        this.nextMenu = (short)16;
                        break;
                    }
                    case 1: {
                        this.nextMode = 0;
                        this.nextMenu = (short)4;
                        break;
                    }
                    case 2: {
                        this.nextMode = 0;
                        this.nextMenu = 1;
                        break;
                    }
                    case 3: {
                        this.nextMode = 0;
                        this.nextMenu = (short)21;
                        break;
                    }
                    case 4: {
                        this.nextMode = 0;
                        this.nextMenu = (short)9;
                        break;
                    }
                    case 5: {
                        this.nextMode = (short)-1;
                        this.nextMenu = (short)-2;
                    }
                }
                break;
            }
            case 1: {
                if (this.optionsMenuState != 1) {
                    return;
                }
                switch (this.optionSelected) {
                    case 0: {
                        this.nextMode = 0;
                        this.nextMenu = (short)10;
                        break;
                    }
                    case 1: {
                        this.nextMode = 0;
                        this.nextMenu = (short)20;
                    }
                }
                break;
            }
            case 15: {
                if (this.optionSelected >= SniperMIDlet.getUnlockStages()) break;
                SniperMIDlet.setStageToLoad(this.optionSelected);
                this.nextMode = 0;
                this.nextMenu = (short)6;
                break;
            }
            case 9: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                this.updatePageToShow();
                break;
            }
            case 7: {
                if (SniperMIDlet.playingArcadeMode) {
                    if (SniperMIDlet.getStageToLoad() == 0) {
                        this.setNextState((short)0);
                        this.setNextMenu((short)18);
                        break;
                    }
                    this.setNextState((short)0);
                    this.setNextMenu((short)6);
                    break;
                }
                this.setNextState((short)0);
                this.setNextMenu((short)0);
                break;
            }
            case 10: {
                switch (this.optionSelected) {
                    case 0: {
                        this.switchMusic();
                        this.optionsMenuState = 1;
                        break block0;
                    }
                    case 1: {
                        this.optionsMenuState = 1;
                    }
                }
            }
        }
        if (this.optionsMenu) {
            this.toptionsMenu = System.currentTimeMillis();
            this.optionsMenuState = 2;
        }
    }

    public void switchMusic() {
        if (this.gameMidlet.soundEngine.isMusicEnable()) {
            this.gameMidlet.soundEngine.stopMainTheme();
            this.gameMidlet.soundEngine.disableMusic();
            this.vsOptions.setElementAt(Resources.getString(11), 0);
        } else {
            this.vsOptions.setElementAt(Resources.getString(10), 0);
            this.gameMidlet.soundEngine.enableMusic();
            this.gameMidlet.soundEngine.playMainTheme();
        }
    }

    private final void setNextMenu(short newMenu) {
        this.gameMidlet.setNextMenuToLoad(newMenu);
        this.running = false;
        this.repaint();
    }

    private final void setNextState(short newState) {
        this.gameMidlet.setNewMode(newState);
        this.running = false;
    }

    protected final void paint(Graphics g) {
        if (this.running && this.menuReady) {
            if (this.firstTime) {
                g.setColor(-16777216);
                g.fillRect(0, 0, 240, 320);
                this.firstTime = false;
            }
            this.renderSpecificMenuContent(g);
        }
        Console.draw(g);
    }

    public final void renderBackIcon(Graphics g) {
        if (this.menuType == 14) {
            SniperMIDlet.gameFont.drawString(g, Resources.getString(37), this.xBack - 3, this.yBack, 20);
        } else {
            g.drawImage(this.iIconBack, this.xBack, this.yBack, 20);
        }
    }

    public final void renderOk(Graphics g) {
        if (this.menuType == 14) {
            SniperMIDlet.gameFont.drawString(g, Resources.getString(36), this.xOk, this.yOk, 20);
        } else {
            g.drawImage(this.iIconAccept, this.xOk, this.yOk, 20);
        }
    }

    private final void renderWindowCorner(Graphics g, int x, int y) {
        g.setClip(0, 0, 240, 320);
        g.drawImage(this.iWindowCorner, x, y, 20);
    }

    private final void renderUpFrame(Graphics g) {
        g.setClip(0, 0, this.wc1X + 8, this.wc1Y + 8);
        g.setColor(-8421505);
        g.fillRect(MenuCanvas.toPixelX(2), MenuCanvas.toPixelY(4), MenuCanvas.toPixelX(96), MenuCanvas.toPixelY(26));
        g.setColor(0);
        g.drawRect(MenuCanvas.toPixelX(3), MenuCanvas.toPixelY(5), MenuCanvas.toPixelX(93), MenuCanvas.toPixelY(24));
        g.setClip(0, 0, 240, 320);
    }

    private final void renderVolumenBar(Graphics g) {
        g.setColor(-16777216);
        for (int i = 0; i < 10; ++i) {
            if (i < this.volumen) {
                if (this.volumen <= 4) {
                    g.setColor(-16711936);
                } else if (this.volumen > 4 && this.volumen <= 7) {
                    g.setColor(-256);
                } else {
                    g.setColor(-65536);
                }
            } else {
                g.setColor(-16777216);
            }
            g.fillRect(95 + i * 7, 235, 4, 12);
        }
    }

    private final void renderDownFrame(Graphics g) {
        g.setClip(0, 0, this.wc2X + 8, this.wc2Y + 8);
        this.drawStageMapBG(g);
        this.renderWindowCorner(g, this.wc2X, this.wc2Y);
        g.setClip(0, 0, 240, 320);
    }

    private final void renderDistricts(Graphics g) {
        this.drawStageMaps(g);
        this.blink = (this.blink + 1) % 2;
        g.setClip(0, 0, 240, 320);
    }

    private final void renderFace(Graphics g, int x, int y, Image face) {
        g.drawImage(face, x, y, 20);
    }

    private final void renderSkipBriefingIcon(Graphics g) {
        for (int i = 0; i < 2; ++i) {
            g.drawImage(this.iSkip, i * 10 + 6, 298, 20);
        }
    }

    private final void renderNextPageIcon(Graphics g) {
        g.drawImage(this.iSkip, 224, 298, 20);
    }

    private final void renderBriefing(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        block0 : switch (this.briefingState) {
            case 0: {
                switch (this.visibleFlag) {
                    case 0: {
                        this.renderWindowCorner(g, this.wc1X, this.wc1Y);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.renderUpFrame(g);
                break;
            }
            case 2: {
                this.renderUpFrame(g);
                switch (this.visibleFlag) {
                    case 0: {
                        this.renderWindowCorner(g, this.wc2X, this.wc2Y);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.renderUpFrame(g);
                this.renderDownFrame(g);
                break;
            }
            case 4: {
                this.renderUpFrame(g);
                g.setClip(0, 0, 240, 320);
                MenuCanvas.drawImg(g, this.iFace, 25, 17, 10);
                this.renderDistricts(g);
                this.renderSkipBriefingIcon(g);
                this.renderNextPageIcon(g);
                this.renderMissionInfo(g);
            }
        }
    }

    private final void renderLanguageSelection(Graphics g) {
        int y = 45;
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        for (int i = 0; i < 5; ++i) {
            if (i == this.optionSelected) {
                g.setColor(-16711936);
                SniperMIDlet.gameFont.drawString(g, Resources.CHOOSE_YOUR_LANGUAGE[i], 0, 0, 240, 45, 3);
                g.fillRect(103, y - 2, 33, 24);
            }
            g.drawImage(this.iFlags[i], 105, y, 20);
            y += 25;
        }
    }

    private final void determineActualOptionOffset() {
        ++this.counter;
        if (this.counter % 1 == 0) {
            if (this.right) {
                ++this.offset;
                if (this.offset >= 10) {
                    this.left = true;
                    this.right = false;
                }
            } else if (this.left) {
                --this.offset;
                if (this.offset == 0) {
                    this.right = true;
                    this.left = false;
                }
            }
        }
    }

    private final void renderBanners(Graphics g) {
        g.setClip(0, 0, 240, 320);
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 30);
        g.fillRect(0, 290, 240, 30);
    }

    private final void renderRecordMenu(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        g.setColor(-8421505);
        g.fillRect(_Rect0_[0], _Rect0_[1], _Rect0_[2], _Rect0_[3]);
        g.fillRect(_Rect1_[0], _Rect1_[1], _Rect1_[2], _Rect1_[3]);
        g.fillRect(_Rect2_[0], _Rect2_[1], _Rect2_[2], _Rect2_[3]);
        g.fillRect(_Rect3_[0], _Rect3_[1], _Rect3_[2], _Rect3_[3]);
        g.fillRect(_Rect4_[0], _Rect4_[1], _Rect4_[2], _Rect4_[3]);
        this.renderFace(g, 12, 13, this.iFace);
        g.setClip(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, this.attrib, MenuCanvas.toPixelX(30), MenuCanvas.toPixelY(5) - SniperMIDlet.gameFont.fontHeight / 2, MenuCanvas.toPixelX(100), MenuCanvas.toPixelY(36), 6);
        SniperMIDlet.gameFont.drawString(g, this.attribVal, MenuCanvas.toPixelX(66), MenuCanvas.toPixelY(5) - SniperMIDlet.gameFont.fontHeight / 2, MenuCanvas.toPixelX(100), MenuCanvas.toPixelY(36), 6);
        this.drawStageMaps(g);
        g.setClip(0, 0, 240, 320);
        this.renderBackIcon(g);
        this.blink = (this.blink + 1) % 2;
    }

    public static int toPixelX(int x) {
        return x * 240 / 100;
    }

    public static int toPixelY(int y) {
        return y * 320 / 100;
    }

    private void drawStageMapBG(Graphics g) {
        g.setColor(-8421505);
        g.fillRect(MenuCanvas.toPixelX(2), MenuCanvas.toPixelY(35), MenuCanvas.toPixelX(96), MenuCanvas.toPixelY(56));
        g.setColor(0);
        g.drawRect(MenuCanvas.toPixelX(3), MenuCanvas.toPixelY(36), MenuCanvas.toPixelX(93), MenuCanvas.toPixelY(54));
    }

    private void drawStageMaps(Graphics g) {
        this.drawStageMapBG(g);
        g.setClip(0, 0, 240, 320);
        int borderWidth = 2;
        for (int i = 0; i < 4; ++i) {
            if (i == this.optionSelected) continue;
            if (i < SniperMIDlet.getUnlockStages()) {
                g.setColor(65280);
            } else {
                g.setColor(0xFF0000);
            }
            g.fillRect(MenuCanvas.toPixelX(cityOffsets[i][0]) - this.iStageMapsSmall[i].getWidth() / 2 - 1, MenuCanvas.toPixelY(cityOffsets[i][1]) - this.iStageMapsSmall[i].getHeight() / 2 - 1, this.iStageMapsSmall[i].getWidth() + 2, this.iStageMapsSmall[i].getHeight() + 2);
            g.drawImage(this.iStageMapsSmall[i], MenuCanvas.toPixelX(cityOffsets[i][0]), MenuCanvas.toPixelY(cityOffsets[i][1]), 3);
        }
        if (this.blink == 0) {
            if (this.optionSelected < SniperMIDlet.getUnlockStages()) {
                g.setColor(65280);
            } else {
                g.setColor(0xFF0000);
            }
            g.fillRect(MenuCanvas.toPixelX(cityOffsets[this.optionSelected][0]) - this.iStageMapsBig[this.optionSelected].getWidth() / 2 - 1, MenuCanvas.toPixelY(cityOffsets[this.optionSelected][1]) - this.iStageMapsBig[this.optionSelected].getHeight() / 2 - 1, this.iStageMapsBig[this.optionSelected].getWidth() + 2, this.iStageMapsBig[this.optionSelected].getHeight() + 2);
        }
        g.drawImage(this.iStageMapsBig[this.optionSelected], MenuCanvas.toPixelX(cityOffsets[this.optionSelected][0]), MenuCanvas.toPixelY(cityOffsets[this.optionSelected][1]), 3);
    }

    private final void drawMessageBoxBG(Graphics g) {
        g.setColor(-8421505);
        g.fillRect(MenuCanvas.toPixelX(2), MenuCanvas.toPixelY(4), MenuCanvas.toPixelX(96), MenuCanvas.toPixelY(26));
        g.setColor(0);
        g.drawRect(MenuCanvas.toPixelX(3), MenuCanvas.toPixelY(5), MenuCanvas.toPixelX(93), MenuCanvas.toPixelY(24));
    }

    private final void renderMissionMenu(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        this.drawMessageBoxBG(g);
        g.setClip(0, 0, 240, 320);
        MenuCanvas.drawImg(g, this.iFace, 25, 17, 10);
        g.setClip(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, this.attrib, MenuCanvas.toPixelX(30), MenuCanvas.toPixelY(5) - SniperMIDlet.gameFont.fontHeight / 2, MenuCanvas.toPixelX(100), MenuCanvas.toPixelY(32), 6);
        SniperMIDlet.gameFont.drawString(g, this.attribVal, MenuCanvas.toPixelX(60), MenuCanvas.toPixelY(5) - SniperMIDlet.gameFont.fontHeight / 2, MenuCanvas.toPixelX(100), MenuCanvas.toPixelY(32), 6);
        this.drawStageMaps(g);
        g.setClip(0, 0, 240, 320);
        this.renderOk(g);
        this.renderBackIcon(g);
        this.blink = (this.blink + 1) % 2;
    }

    private final void renderEnableSoundMenu(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(39), 0, 0, 240, 320, 3);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(36), this.xOk, this.yOk, 240, 320, 20);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(37), 0, this.yOk, 238, 320, 24);
    }

    public final void renderHelpMenu(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        int soundtxtid = 96;
        SniperMIDlet.gameFont.drawString(g, Resources.getString(59) + Resources.getString(soundtxtid), 12, this.helpTextScroll * 14, 216, 9000, 20);
        g.fillRect(0, 320 - this.iIconBack.getHeight() * 3 / 2, 240, this.iIconBack.getHeight() * 3 / 2);
    }

    private final void renderMenuOptions(Graphics g) {
        int x = 136;
        int y = 204;
        switch (this.optionsMenuState) {
            case 0: {
                x = Math3D.linearInterpolation(340, 136, this.optionsCoef);
                y = 204;
                break;
            }
            case 1: {
                x = 136;
                y = 204;
                break;
            }
            case 2: {
                x = Math3D.linearInterpolation(136, 340, this.optionsCoef);
                y = 204;
            }
        }
        for (int i = 0; i < this.optionsNumber; ++i) {
            int gapX;
            if (i == this.optionSelected && this.optionsMenuState == 1) {
                g.drawImage(this.iMenuCursor, x - 9 - 10, y + SniperMIDlet.gameFont.fontHeight / 2, 6);
                this.determineActualOptionOffset();
                gapX = this.offset;
            } else {
                gapX = 0;
            }
            SniperMIDlet.gameFont.drawString(g, (String)this.vsOptions.elementAt(i), x + gapX, y, 20);
            x -= 5;
            y += 16;
        }
    }

    public final void renderMissionInfo(Graphics g) {
        SniperMIDlet.gameFont.draw(g, System.currentTimeMillis());
    }

    private final void renderBadEnding(Graphics g) {
        g.drawImage(this.iCementery, 0, this.drawingY, 20);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(29), 0, 0, 240, 320, 3);
        this.renderBanners(g);
        switch (this.turn) {
            case -2: 
            case 2: {
                g.drawImage(this.iFadeOutLogo, 0, 30, 20);
            }
        }
        this.renderOk(g);
    }

    private final void renderGoodEnding(Graphics g) {
        g.setColor(-3635934);
        g.fillRect(0, 30, 240, 260);
        g.drawImage(this.iSun, 88, 179, 20);
        if (this.turn != -2) {
            this.helicopterBlades.despX = (short)this.helicopterXPos;
            this.helicopterBlades.despY = (short)this.helicopterYPos;
            g.setClip(0, 0, 240, 320);
            this.helicopterBlades.draw(g, System.currentTimeMillis());
            g.setClip(0, 0, 240, 320);
            g.drawImage(this.iHelicopter, this.helicopterXPos, this.helicopterYPos, 20);
            g.drawImage(this.iBuilding, 0, 290, 36);
        }
        switch (this.turn) {
            case 0: {
                g.setColor(-8421505);
                g.fillRect(_Rect0_[0], _Rect0_[1] + 30, _Rect0_[2], _Rect0_[3]);
                g.fillRect(_Rect1_[0], _Rect1_[1] + 30, _Rect1_[2], _Rect1_[3]);
                g.fillRect(_Rect2_[0], _Rect2_[1] + 30, _Rect2_[2], _Rect2_[3]);
                g.fillRect(_Rect3_[0], _Rect3_[1] + 30, _Rect3_[2], _Rect3_[3]);
                g.fillRect(_Rect4_[0], _Rect4_[1] + 30, _Rect4_[2], _Rect4_[3]);
                this.renderFace(g, 12, 43, this.iFace);
                break;
            }
            case 1: {
                g.setColor(-8421505);
                g.fillRect(_Rect0_[0], _Rect0_[1] + 30, _Rect0_[2], _Rect0_[3]);
                g.fillRect(_Rect1_[0], _Rect1_[1] + 30, _Rect1_[2], _Rect1_[3]);
                g.fillRect(_Rect2_[0], _Rect2_[1] + 30, _Rect2_[2], _Rect2_[3]);
                g.fillRect(_Rect3_[0], _Rect3_[1] + 30, _Rect3_[2], _Rect3_[3]);
                g.fillRect(_Rect4_[0], _Rect4_[1] + 30, _Rect4_[2], _Rect4_[3]);
                this.renderFace(g, 151, 43, this.iSniperFace);
            }
        }
        g.setClip(0, 0, 240, 320);
        this.renderBanners(g);
    }

    public static void drawImg(Graphics g, Image img, int relate_x, int relate_y, int anchor) {
        g.drawImage(img, MenuCanvas.toPixelX(relate_x), MenuCanvas.toPixelY(relate_y), anchor);
    }

    private final void renderSpecificMenuContent(Graphics g) {
        switch (this.menuType) {
            case -1: {
                g.setColor(-16777216);
                g.fillRect(0, 0, 240, 320);
                switch (this.menuLogoPhase) {
                    case 0: {
                        g.setColor(-1);
                        g.fillRect(0, 0, 240, 320);
                        g.drawImage(this.iMOLogo, 120, 160, 3);
                        break;
                    }
                    case 1: {
                        g.setColor(-1);
                        g.fillRect(0, 0, 240, 320);
                        g.drawImage(this.iCMCCLogo, 120, 160, 3);
                        break;
                    }
                    case 2: {
                        g.setColor(0);
                        g.fillRect(0, 0, 240, 320);
                        g.drawImage(this.iLogo, this.xLogo, this.yLogo, 20);
                    }
                }
                break;
            }
            case 12: {
                this.renderEnableSoundMenu(g);
                break;
            }
            case 0: {
                g.drawImage(this.iMenuBackground, 0, 0, 20);
                this.renderMenuOptions(g);
                if (this.menuType == 10 && this.optionSelected == 1) {
                    this.renderVolumenBar(g);
                }
                this.renderOk(g);
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 16: 
            case 21: {
                g.drawImage(this.iMenuBackground, 0, 0, 20);
                this.renderMenuOptions(g);
                this.renderBackIcon(g);
                if (this.menuType == 10 && this.optionSelected == 1) {
                    this.renderVolumenBar(g);
                }
                this.renderOk(g);
                break;
            }
            case 17: {
                this.renderBadEnding(g);
                break;
            }
            case 18: {
                switch (this.turn) {
                    case -1: {
                        this.renderGoodEnding(g);
                        break;
                    }
                    case 0: {
                        this.renderGoodEnding(g);
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(42), _Text_[0], _Text_[1] + 30, _Text_[2], _Text_[3], 20);
                        break;
                    }
                    case 1: {
                        this.renderGoodEnding(g);
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(58), 12, 43, _Text_[2], _Text_[3], 20);
                        break;
                    }
                    case -2: 
                    case 2: {
                        this.renderGoodEnding(g);
                        g.drawImage(this.iFadeOutLogo, 0, 30, 20);
                        break;
                    }
                    case 4: {
                        g.setColor(-16777216);
                        g.fillRect(0, 0, 240, 320);
                        SniperMIDlet.gameFont.drawString(g, Resources.getString(9) + " : " + CHEATS[this.unlockCheatIndex], 0, 0, 240, 320, 3);
                    }
                }
                this.renderOk(g);
                break;
            }
            case 14: {
                this.renderWarningFrame(g);
                this.renderBackIcon(g);
                this.renderOk(g);
                break;
            }
            case 11: 
            case 20: {
                this.renderLanguageSelection(g);
                this.renderOk(g);
                if (this.menuType != 20) break;
                this.renderBackIcon(g);
                break;
            }
            case 6: {
                this.renderBriefing(g);
                break;
            }
            case 7: {
                this.renderMissionResult(g);
                g.setClip(0, 0, 240, 320);
                this.renderNextPageIcon(g);
                break;
            }
            case 4: {
                this.renderHelpMenu(g);
                this.renderBackIcon(g);
                break;
            }
            case 9: {
                this.renderCredits(g);
                this.renderBackIcon(g);
                break;
            }
            case 2: {
                this.renderRecordMenu(g);
                break;
            }
            case 15: {
                this.renderMissionMenu(g);
                break;
            }
            case 19: {
                this.renderPasswordMenu(g);
                this.renderBackIcon(g);
            }
        }
    }

    private final void renderPasswordMenu(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.iInsertRecord, this.xInsertRecordImage, this.yInsertRecordImage, 20);
        g.drawImage(this.iMenuCursor, this.xCursor - 4, this.yCursor - 4, 20);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(23) + this.password, 0, this.yInsertRecordImage + this.iInsertRecord.getHeight() + 5, 240, 20, 3);
        if (this.renderMessage) {
            SniperMIDlet.gameFont.drawString(g, this.messageToRender, 0, this.yInsertRecordImage + this.iInsertRecord.getHeight() + 20, 240, 20, 3);
            if (System.currentTimeMillis() - this.initMessageTime > 1000L) {
                this.renderMessage = false;
            }
        }
    }

    private final void renderCredits(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, Resources.getString(48), 0, 0, 240, 160, 3);
    }

    private final void renderWarningFrame(Graphics g) {
        SniperMIDlet.gameFont.drawString(g, Resources.getString(41), 58, 121, 124, 78, 3);
    }

    private final void renderMissionResult(Graphics g) {
        g.setColor(-16777216);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.iClipBoard, this.clipBrdX, this.clipBrdY, 20);
        g.setClip(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, this.title, this.clipBrdX, this.clipBrdY + MenuCanvas.toPixelY(5), this.clipBrdW, 16, 3);
        SniperMIDlet.gameFont.drawString(g, this.categories, this.clipBrdX, this.clipBrdY + MenuCanvas.toPixelY(20), this.clipBrdW / 2, this.clipBrdH, 24);
        SniperMIDlet.gameFont.drawString(g, this.categoryValues, this.clipBrdX + this.clipBrdW / 2 + MenuCanvas.toPixelX(10), this.clipBrdY + MenuCanvas.toPixelY(20), this.clipBrdW / 2, this.clipBrdH, 20);
        g.setClip(0, 0, 240, 320);
        this.grades.despX = (short)(this.clipBrdX + this.clipBrdW / 2 + MenuCanvas.toPixelX(10));
        this.grades.despY = (short)(this.clipBrdY + MenuCanvas.toPixelY(20) + (SniperMIDlet.gameFont.fontHeight + SniperMIDlet.gameFont.lineSpacing) * 4);
        this.grades.drawSpecifiedFrame(g, this.categoryImageIndex);
    }

    private void resetInitDemoTime() {
        this.initDemoTime = System.currentTimeMillis();
    }

    private void checkIfWehaveToEnterDemoMode(long time) {
        long elapsedTime = time - this.initDemoTime;
        if (elapsedTime >= 5000L && this.gameMidlet.isScreenSaverEnable()) {
            this.setNextState((short)2);
        }
    }

    private final void updateScrollPosition() {
        --this.scrollY;
        if (this.scrollY <= -303) {
            this.scrollY = -303;
        }
    }

    private final void updateMenuLogoPhase(long time) {
        if (this.menuLogoPhase < 2) {
            this.menuLogoPhase = (byte)(this.menuLogoPhase + 1);
            this.initLogoTime = time;
            switch (this.menuLogoPhase) {
                case 1: 
                case 2: {
                    this.buildFadeOutImage(this.iLogo.getWidth(), this.iLogo.getHeight(), 0);
                }
            }
        } else {
            this.setNextMenu((short)0);
        }
    }

    private final void updateFadeOutImage(long time) {
        if (time >= 1500L) {
            float coef = (float)(time - 1500L) * 1.0f / 1500.0f;
            int alpha = Math3D.linearInterpolation(0, 255, coef);
            switch (this.menuLogoPhase) {
                case 1: {
                    this.buildFadeOutImage(240, 320, alpha);
                    break;
                }
                case 2: {
                    this.buildFadeOutImage(this.iLogo.getWidth(), this.iLogo.getHeight(), alpha);
                }
            }
        }
    }

    private final void processMenu() {
        Input.UpdateKey();
        if (Input.IsKeyPressed(65536)) {
            this.processLeftSoftButton();
        }
        if (Input.IsKeyPressed(131072)) {
            this.processRightSoftButton();
        }
        if (Input.IsKeyCombo(SniperCanvas.Cheating_UnlockAll)) {
            SniperMIDlet.unlockStages = 4;
        }
        long actualTime = System.currentTimeMillis();
        switch (this.menuType) {
            case 4: {
                break;
            }
            case -1: {
                long elapsedTime = actualTime - this.initLogoTime;
                this.updateFadeOutImage(elapsedTime);
                if (elapsedTime < 3000L) break;
                this.updateMenuLogoPhase(actualTime);
                break;
            }
            case 17: {
                switch (this.turn) {
                    case -2: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 5000L) {
                            this.tInitTurn = actualTime;
                            this.turn = (byte)3;
                            break;
                        }
                        float coef = (float)tElapsed * 1.0f / 5000.0f;
                        int alpha = Math3D.linearInterpolation(255, 0, coef);
                        this.buildFadeOutImage(240, 260, alpha);
                        break;
                    }
                    case 3: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 5000L) {
                            this.turn = (byte)2;
                            this.tInitTurn = actualTime;
                            break;
                        }
                        float coef = (float)tElapsed * 1.0f / 6000.0f;
                        this.drawingY = Math3D.linearInterpolation(30, 31, coef);
                        break;
                    }
                    case 2: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 5000L) {
                            this.setNextMenu((short)0);
                            break;
                        }
                        float coef = (float)tElapsed * 1.0f / 5000.0f;
                        int alpha = Math3D.linearInterpolation(0, 255, coef);
                        this.buildFadeOutImage(240, 260, alpha);
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                switch (this.optionsMenuState) {
                    case 0: {
                        long tElapsed = actualTime - this.toptionsMenu;
                        this.optionsCoef = (float)tElapsed * 1.0f / 300.0f;
                        if (tElapsed <= 300L) break;
                        this.optionsMenuState = 1;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        long tElapsed = actualTime - this.toptionsMenu;
                        this.optionsCoef = (float)tElapsed * 1.0f / 300.0f;
                        if (tElapsed <= 300L) break;
                        this.setNextState(this.nextMode);
                        this.setNextMenu(this.nextMenu);
                    }
                }
                if (this.menuType != 0) break;
                this.checkIfWehaveToEnterDemoMode(actualTime);
                break;
            }
            case 18: {
                switch (this.turn) {
                    case -2: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 5000L) {
                            this.tInitTurn = actualTime;
                            this.helicopterTime = actualTime;
                            this.actualWaypoint = 0;
                            this.nextWaypoint = 1;
                            this.cityYPos = 320;
                            this.yInit = 320;
                            this.yFinal = 201;
                            this.turn = (byte)-1;
                            break;
                        }
                        int alpha = Math3D.linearInterpolation(255, 0, (float)tElapsed * 1.0f / 5000.0f);
                        this.buildFadeOutImage(240, 260, alpha);
                        break;
                    }
                    case -1: {
                        long tElapsed = actualTime - this.helicopterTime;
                        float coef = (float)tElapsed * 1.0f / 5000.0f;
                        if (coef > 1.0f) {
                            if (this.nextWaypoint < 2) {
                                this.yFinal = 201;
                                this.yInit = 201;
                                this.actualWaypoint = this.nextWaypoint++;
                                this.helicopterTime = actualTime;
                                coef = 0.0f;
                            } else {
                                this.tInitTurn = actualTime;
                                this.turn = 0;
                            }
                        }
                        this.cityYPos = Math3D.linearInterpolation(this.yInit, this.yFinal, coef);
                        this.helicopterXPos = Math3D.linearInterpolation(HELICOPTER_WAYPOINTS[this.actualWaypoint][0], HELICOPTER_WAYPOINTS[this.nextWaypoint][0], coef);
                        this.helicopterYPos = Math3D.linearInterpolation(HELICOPTER_WAYPOINTS[this.actualWaypoint][1], HELICOPTER_WAYPOINTS[this.nextWaypoint][1], coef);
                        break;
                    }
                    case 0: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed <= 5000L) break;
                        this.turn = 1;
                        this.tInitTurn = actualTime;
                        break;
                    }
                    case 1: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed <= 5000L) break;
                        this.turn = (byte)2;
                        this.tInitTurn = actualTime;
                        this.buildFadeOutImage(240, 260, 0);
                        break;
                    }
                    case 2: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 5000L) {
                            this.turn = (byte)4;
                            this.tInitTurn = actualTime;
                            this.unlockCheatIndex = Math3D.getRandNumber(0, 2);
                            break;
                        }
                        int alpha = Math3D.linearInterpolation(0, 255, (float)tElapsed * 1.0f / 5000.0f);
                        this.buildFadeOutImage(240, 260, alpha);
                        break;
                    }
                    case 4: {
                        long tElapsed = actualTime - this.tInitTurn;
                        if (tElapsed > 10000L) {
                            this.setNextMenu((short)9);
                            break;
                        }
                        int alpha = Math3D.linearInterpolation(0, 255, (float)tElapsed * 1.0f / 5000.0f);
                    }
                }
                break;
            }
            case 3: 
            case 19: {
                if (this.leftPressed) {
                    this.moveToLeft();
                }
                if (this.rightPressed) {
                    this.moveToRight();
                }
                if (this.downPressed) {
                    this.moveToDown();
                }
                if (!this.upPressed) break;
                this.moveToUp();
                break;
            }
            case 6: {
                this.processBriefingState();
                break;
            }
        }
    }

    public final void run() {
        try {
            this.running = true;
            while (this.running) {
                this.processMenu();
                this.repaint();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {}
            }
            this.unloadMenuResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

