/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import z.SniperCanvas;

public class AdvanceBB {
    private Mesh bbMesh;
    private Appearance app;
    private Texture2D[] textures;
    private int numImages;
    private float scale2;
    private boolean isVisible;
    private Group cameraGroup;
    private float x;
    private float y;
    private float z;
    private int actAnimImg;
    private int actAnimLength;
    private int actAnimStartIdx;
    private boolean repeat;
    private int timeForEachFrame;
    private boolean animated;
    private boolean animationConfigured;
    private int animTick = 0;

    public AdvanceBB(Texture2D[] aTexture, Group camGroup, float size, float aspectRatio, boolean shootable) {
        this.cameraGroup = camGroup;
        VertexBuffer vb = this.makeGeometry();
        int[] indicies = new int[]{0, 3, 2, 2, 1, 0};
        int[] stripLens = new int[]{3, 3};
        TriangleStripArray ib = new TriangleStripArray(indicies, stripLens);
        this.textures = aTexture;
        this.app = this.makeAppearance(this.textures[0]);
        this.resetAnimationAttributes();
        this.bbMesh = new Mesh(vb, (IndexBuffer)ib, this.app);
        this.scale2 = size * 0.5f;
        this.bbMesh.scale(this.scale2 * aspectRatio, this.scale2, this.scale2);
        this.bbMesh.setTranslation(0.0f, this.scale2, 0.0f);
        this.bbMesh.setAlignment((Node)this.cameraGroup, 148, (Node)this.cameraGroup, 147);
        this.bbMesh.setPickingEnable(shootable);
        this.isVisible = false;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    private final VertexBuffer makeGeometry() {
        short[] verts = new short[]{-1, 1, 0, 1, 1, 0, 1, -1, 0, -1, -1, 0};
        VertexArray va = new VertexArray(verts.length / 3, 3, 2);
        va.set(0, verts.length / 3, verts);
        short[] tcs = new short[]{0, 0, 1, 0, 1, 1, 0, 1};
        VertexArray texArray = new VertexArray(tcs.length / 2, 2, 2);
        texArray.set(0, tcs.length / 2, tcs);
        VertexBuffer vb = new VertexBuffer();
        vb.setPositions(va, 1.0f, null);
        vb.setTexCoords(0, texArray, 1.0f, null);
        return vb;
    }

    private final Appearance makeAppearance(Texture2D tex) {
        this.app = new Appearance();
        CompositingMode compMode = new CompositingMode();
        compMode.setBlending(64);
        this.app.setCompositingMode(compMode);
        this.app.setTexture(0, tex);
        PolygonMode billboardPolygonMode = new PolygonMode();
        billboardPolygonMode.setPerspectiveCorrectionEnable(true);
        billboardPolygonMode.setCulling(160);
        this.app.setPolygonMode(billboardPolygonMode);
        return this.app;
    }

    public final void setPosition(float xNew, float yNew, float zNew) {
        this.bbMesh.setTranslation(-this.x, -this.y, -this.z);
        this.x = xNew;
        this.y = yNew + this.scale2;
        this.z = zNew;
        this.bbMesh.setTranslation(this.x, this.y, this.z);
    }

    public final float getScale() {
        return this.scale2;
    }

    public final void setRepeatMode(boolean value) {
        this.repeat = value;
    }

    public final void setRenderable(boolean renderable) {
        this.bbMesh.setRenderingEnable(renderable);
    }

    public final void setVisible(boolean visible) {
        this.isVisible = visible;
        if (this.isVisible) {
            this.bbMesh.setRenderingEnable(true);
            this.actAnimImg = this.animated ? this.actAnimStartIdx : 0;
        } else {
            this.bbMesh.setRenderingEnable(false);
        }
    }

    public final void resetAnimationAttributes() {
        this.actAnimStartIdx = 0;
        this.actAnimLength = 0;
        this.actAnimImg = 0;
        this.animated = false;
        this.repeat = false;
        this.animationConfigured = false;
    }

    public final void validateAnimation(boolean value) {
        this.animationConfigured = value;
    }

    public final void setAnimationToPlay(int startIndex, int animationImages, boolean loop, int timeForEachFrame) {
        this.actAnimLength = animationImages;
        this.actAnimStartIdx = startIndex;
        this.actAnimImg = startIndex;
        this.repeat = loop;
        this.timeForEachFrame = timeForEachFrame;
        this.animated = true;
        this.app.setTexture(0, this.textures[startIndex]);
    }

    public final void resetAnimation() {
        this.actAnimImg = 0;
    }

    public final void setFrameToShow(int frameIndex) {
        if (frameIndex >= 0 && frameIndex < this.textures.length) {
            this.app.setTexture(0, this.textures[frameIndex]);
            this.resetAnimationAttributes();
        }
    }

    public final boolean animationEnd() {
        return this.actAnimImg >= this.actAnimStartIdx + this.actAnimLength - 1;
    }

    public final void update(long actualEngineTime) {
        if (this.animationConfigured && this.isVisible) {
            this.bbMesh.align((Node)this.cameraGroup);
            if ((this.animTick += SniperCanvas.elapsedTime) > this.timeForEachFrame) {
                this.animTick = 0;
                ++this.actAnimImg;
            }
            if (this.repeat) {
                this.actAnimImg = this.actAnimImg % this.actAnimLength + this.actAnimStartIdx;
                this.app.setTexture(0, this.textures[this.actAnimImg]);
            } else {
                if (this.animationEnd()) {
                    this.actAnimImg = this.actAnimStartIdx + this.actAnimLength - 1;
                }
                this.app.setTexture(0, this.textures[this.actAnimImg]);
            }
        }
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final int getCurrentAnimationImageIndex() {
        return this.actAnimImg;
    }

    public final Mesh getAdvanceBBMesh() {
        return this.bbMesh;
    }
}

