/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import z.AVPartInfo;
import z.AdvanceBB;
import z.AdvanceSceneObject;
import z.Cordic;
import z.GameEngine;
import z.Math3D;
import z.SniperCanvas;
import z.SniperGunCamera;
import z.SniperMIDlet;
import z.Vector3D;

public class ShootableObject
extends AdvanceSceneObject {
    private static final int ACCURACY_TERRORIST1 = 10;
    private static final int ACCURACY_TERRORIST2 = 10;
    private static final int ACCURACY_TERRORIST3 = 10;
    private static final int ACCURACY_PRIMARY_WEAPON = 10;
    private static final int ACCURACY_SECONDARY_WEAPON = 1;
    private static final int t_RenderWeaponLife = 1500;
    private static final int t_TrackingTime = 1400;
    private static final int[][] t_MinTimeToDiscoverPlayer = new int[][]{{7000, 7000, 7000}, {6000, 6000, 6000}, {6000, 6000, 6000}, {5000, 5000, 5000}};
    private static final int[][] t_MaxTimeToDiscoverPlayer = new int[][]{{11000, 11000, 10000}, {10000, 10000, 10000}, {10000, 10000, 10000}, {9000, 9000, 9000}};
    private static final int[][] t_MinWaitTimeToShoot = new int[][]{{10000, 10000, 9000}, {9000, 8000, 8000}, {7000, 7000, 7000}, {70000, 60000, 6000}};
    private static final int[][] t_MaxWaitTimeToShoot = new int[][]{{18000, 17000, 16000}, {15000, 15000, 14000}, {14000, 12000, 10000}, {10000, 10000, 10000}};
    private static final int t_MinLiveTime = 11000;
    private static final int t_MaxLiveTime = 12000;
    private static final int t_MinWaitTimeToShootHW = 11800;
    private static final int t_MaxWaitTimeToShootHW = 17000;
    private static final int t_MinWaitTimeToShootLW = 5800;
    private static final int t_MaxWaitTimeToShootLW = 8000;
    private static final int _Firts_Valid_Animation_State_ = 0;
    private static final int _AS_Patrol_ = 0;
    private static final int _AS_Shooting_ = 1;
    private static final int _AS_Dying_ = 2;
    private static final int _Last_valid_Animation_State_ = 2;
    private static final int _Life_Width_ = 12;
    private static final int _Life_Height_ = 5;
    private static final int _Life_Color_ = -12779776;
    public static final int MIN_R1 = 30;
    public static final int MAX_R1 = 90;
    public static final int MIN_R2 = 5;
    public static final int MAX_R2 = 30;
    public static final int R2_GAP = 4;
    public static final int GOOD_HUD_COLOR = -16776961;
    public static final int _AnimationState_PATROL_ = 0;
    public static final int _AnimationState_SHOOTING_ = 1;
    public static final int _AnimationState_IMPACT_ = 2;
    public static final int _AnimationState_DYING_ = 3;
    private byte shootableParts;
    private int animationState;
    private byte visible;
    private int side;
    private short angle;
    private short arrowAngle;
    private boolean hostageAlive;
    private boolean alive;
    private boolean enemy;
    private boolean discovered;
    private boolean validTimes;
    private boolean dying = false;
    private boolean animateArrow;
    private boolean hasSeenPlayer;
    private boolean endTracking;
    private boolean renderWeaponLife;
    private boolean[] active;
    private long initRenderWeaponLife;
    private long initTrackingTime;
    private long initLifeTime;
    private long lifeTime;
    private long timeToDiscoverPlayer;
    private long[] timeToShoot;
    private long[] finalCount;
    private int positionIndex;
    private AdvanceBB[] shotSequence;
    GameEngine game;
    public int dyingBlink;

    public ShootableObject(int objectId, GameEngine game) {
        super(objectId);
        this.game = game;
    }

    public final void initShootableObject(int objectCategory, int objectSubcategory, float x, float y, float z, float scale, float heading, Group cameraGroup, World scene, int posIndex) {
        this.visible = 0;
        if (objectCategory != this.category || objectSubcategory != this.subCategory) {
            this.freeMemory();
        }
        this.initSceneObject(objectCategory, objectSubcategory, x, y, z, scale, heading, cameraGroup, scene);
        this.determineIfIsAnEnemy();
        this.allocateMemoryForArrays();
        this.initVariables();
        this.positionIndex = posIndex;
    }

    public final void enableRenderWeaponLife(int index) {
        this.renderWeaponLife = true;
        this.initRenderWeaponLife = GameEngine.getGameTime();
        this.side = index;
    }

    public final boolean isAnEnemy() {
        return this.enemy;
    }

    public final int getAnimationState() {
        return this.animationState;
    }

    public final void activateAnimation(long time) {
        switch (this.category) {
            case 1: {
                switch (this.subCategory) {
                    case 50: {
                        this.initPatrolAnimation();
                    }
                }
                break;
            }
            case 2: {
                this.billboard.setVisible(true);
                break;
            }
        }
    }

    private final void determineIfIsAnEnemy() {
        block0 : switch (this.category) {
            case 3: {
                this.enemy = true;
                switch (this.subCategory) {
                    case 30: {
                        this.shootableParts = (byte)3;
                        break block0;
                    }
                    case 31: {
                        this.shootableParts = (byte)4;
                        break block0;
                    }
                    case 32: {
                        this.shootableParts = (byte)4;
                        break block0;
                    }
                    case 33: {
                        this.shootableParts = (byte)4;
                        break block0;
                    }
                }
                this.shootableParts = (byte)2;
                break;
            }
            case 1: {
                switch (this.subCategory) {
                    case 50: {
                        this.enemy = false;
                        break;
                    }
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: {
                        this.enemy = true;
                    }
                }
                this.shootableParts = 1;
                break;
            }
            case 2: {
                this.shootableParts = 1;
                this.enemy = false;
                break;
            }
        }
    }

    public final boolean isAlive() {
        return this.alive;
    }

    public final void kill() {
        for (int i = 0; i < this.shootableParts; ++i) {
            this.desactivate(i);
        }
    }

    public final void initTimes(long time) {
        this.initLifeTime = time;
        if (this.enemy) {
            this.timeToDiscoverPlayer = Math3D.getRandNumber(t_MinTimeToDiscoverPlayer[GameEngine.stage][this.game.substage], t_MaxTimeToDiscoverPlayer[GameEngine.stage][this.game.substage]);
            for (int i = 0; i < this.shootableParts; ++i) {
                this.timeToShoot[i] = Math3D.getRandNumber(t_MinWaitTimeToShoot[GameEngine.stage][this.game.substage], t_MaxWaitTimeToShoot[GameEngine.stage][this.game.substage]);
            }
        } else {
            this.lifeTime = Math3D.getRandNumber(11000, 12000);
        }
        this.validTimes = true;
    }

    public final void initWeaponsTimes(long time) {
        this.initLifeTime = time;
        block6: for (int i = 0; i < this.objectMeshes.length; ++i) {
            AVPartInfo bossPart = (AVPartInfo)this.objectMeshes[i].getUserObject();
            int index = bossPart.getWeaponIndex();
            if (index == -1) continue;
            int type = bossPart.getExtremityType();
            switch (type) {
                case 70: {
                    continue block6;
                }
                case 71: {
                    continue block6;
                }
                case 72: {
                    this.timeToShoot[index] = Math3D.getRandNumber(11800, 17000);
                    continue block6;
                }
                case 73: {
                    this.timeToShoot[index] = Math3D.getRandNumber(5800, 8000);
                }
            }
        }
        this.validTimes = true;
    }

    private final void initVariables() {
        this.alive = true;
        this.discovered = false;
        this.dying = false;
        this.validTimes = false;
        this.animateArrow = false;
        this.hasSeenPlayer = false;
        this.endTracking = false;
        this.hostageAlive = this.category == 1 && this.subCategory == 53;
        for (int i = 0; i < this.shootableParts; ++i) {
            this.active[i] = true;
        }
        if (this.category == 1) {
            this.initPatrolAnimation();
        }
    }

    private final void initPatrolAnimation() {
        this.animationState = 0;
        switch (this.subCategory) {
            case 50: {
                this.billboard.setFrameToShow(0);
                this.billboard.setVisible(true);
                break;
            }
            case 51: {
                this.billboard.setAnimationToPlay(0, 3, true, 100);
                this.billboard.setVisible(true);
                this.billboard.validateAnimation(true);
                break;
            }
            case 52: {
                this.billboard.setAnimationToPlay(0, 3, true, 100);
                this.billboard.setVisible(true);
                this.billboard.validateAnimation(true);
                break;
            }
            case 53: {
                this.billboard.setAnimationToPlay(0, 3, true, 100);
                this.billboard.setVisible(true);
                this.billboard.validateAnimation(true);
                break;
            }
            case 54: {
                this.billboard.setAnimationToPlay(0, 3, true, 100);
                this.billboard.setVisible(true);
                this.billboard.validateAnimation(true);
                break;
            }
        }
    }

    public final void initDyingAnimation() {
        int dyingFrameTime = 200;
        this.animationState = 3;
        switch (this.subCategory) {
            case 50: {
                this.billboard.setAnimationToPlay(0, 4, false, 100);
                this.billboard.validateAnimation(true);
                break;
            }
            case 51: {
                this.billboard.setAnimationToPlay(6, 3, false, 200);
                this.billboard.validateAnimation(true);
                break;
            }
            case 52: {
                this.billboard.setAnimationToPlay(5, 3, false, 200);
                this.billboard.validateAnimation(true);
                break;
            }
            case 53: {
                if (this.hostageAlive) {
                    this.billboard.setAnimationToPlay(5, 4, false, 200);
                    this.billboard.validateAnimation(true);
                    break;
                }
                this.billboard.setAnimationToPlay(10, 2, false, 200);
                this.billboard.validateAnimation(true);
                break;
            }
            case 54: {
                this.billboard.setAnimationToPlay(5, 3, false, 200);
                this.billboard.validateAnimation(true);
                break;
            }
        }
    }

    public final void initImpactAnimation() {
        this.animationState = 2;
        switch (this.subCategory) {
            case 50: {
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                this.billboard.setAnimationToPlay(3, 2, false, 100);
                this.billboard.validateAnimation(true);
                break;
            }
            case 53: {
                break;
            }
            case 54: {
                break;
            }
        }
    }

    public final void initShootingAnimation() {
        this.animationState = 1;
        switch (this.subCategory) {
            case 50: {
                break;
            }
            case 51: {
                this.billboard.setFrameToShow(5);
                break;
            }
            case 52: {
                this.billboard.setFrameToShow(4);
                break;
            }
            case 53: {
                if (this.hostageAlive) {
                    this.billboard.setFrameToShow(2);
                    break;
                }
                this.billboard.setFrameToShow(4);
                break;
            }
            case 54: {
                this.billboard.setFrameToShow(4);
                break;
            }
        }
    }

    public final void setHostageAlive(boolean value) {
        this.hostageAlive = value;
    }

    public final boolean isHostageAlive() {
        return this.hostageAlive;
    }

    public final void setDyingValue(boolean value) {
        this.dying = value;
    }

    public final boolean isDying() {
        return this.dying;
    }

    private final void allocateMemoryForArrays() {
        if (this.shootableParts > 0) {
            if (this.enemy) {
                if (this.timeToShoot == null) {
                    this.timeToShoot = new long[this.shootableParts];
                }
                if (this.finalCount == null) {
                    this.finalCount = new long[this.shootableParts];
                }
                if (this.category == 1 && this.shotSequence == null) {
                    this.initShotSequenceBillBoard();
                }
            }
            if (this.active == null) {
                this.active = new boolean[this.shootableParts];
            }
        }
    }

    private final void initShotSequenceBillBoard() {
        this.shotSequence = new AdvanceBB[this.shootableParts];
        for (int i = 0; i < this.shootableParts; ++i) {
            this.shotSequence[i] = new AdvanceBB(GameEngine.textureUnits[11], this.camGroup, 0.03f, 1.0f, false);
            this.shotSequence[i].setVisible(false);
            this.shotSequence[i].setAnimationToPlay(0, 3, false, 50);
            this.worldRef.addChild((Node)this.shotSequence[i].getAdvanceBBMesh());
        }
    }

    private final void updateShotSequence() {
        for (int i = 0; i < this.shootableParts; ++i) {
            if (this.shotSequence == null) continue;
            this.shotSequence[i].update(GameEngine.getGameTime());
            if (!this.shotSequence[i].animationEnd()) continue;
            this.shotSequence[i].setVisible(false);
        }
    }

    private final void freeMemory() {
        this.timeToShoot = null;
        this.finalCount = null;
        this.active = null;
        this.shotSequence = null;
        System.gc();
    }

    private final int calculateYValue(int x, int radius, int a, int b) {
        int b2 = b * b;
        int a2 = a * a;
        int x2 = x * x;
        int radius2 = radius * radius;
        int y2 = radius2 + 2 * a + 2 * b - b2 - a2 - x2;
        return (int)Math3D.sqrt(y2);
    }

    private final int getRadiusToUse(float value, boolean zoomOn) {
        int end;
        int init;
        if (zoomOn) {
            if (this.category == 3) {
                init = 50;
                end = 10;
            } else {
                init = 90;
                end = 30;
            }
        } else {
            init = 30;
            end = 5;
        }
        if (value <= 0.0f) {
            return init;
        }
        if (value >= 1.0f) {
            return end;
        }
        return Math3D.linearInterpolation(init, end, value);
    }

    private final void getPoint(int i) {
        Transform t = new Transform();
        switch (i) {
            case 0: {
                break;
            }
        }
        t.setIdentity();
    }

    public final Vector3D getCenterPoint(int shootablepart) {
        Transform t;
        try {
            t = new Transform();
            t.postTranslate(this.position.getX(), this.position.getY(), this.position.getZ());
            t.postRotate(this.actHeading, 0.0f, 1.0f, 0.0f);
        }
        catch (Exception e) {
            t = new Transform();
            t.setIdentity();
        }
        switch (this.category) {
            case 3: {
                switch (this.subCategory) {
                    case 30: {
                        switch (shootablepart) {
                            case 0: {
                                return this.bboxes[2].getNewCenter(t);
                            }
                            case 1: {
                                return this.bboxes[3].getNewCenter(t);
                            }
                            case 2: {
                                return this.bboxes[4].getNewCenter(t);
                            }
                            case 3: {
                                return this.bboxes[5].getNewCenter(t);
                            }
                        }
                        return this.bboxes[0].getNewCenter(t);
                    }
                    case 31: {
                        switch (shootablepart) {
                            case 0: {
                                return this.bboxes[2].getNewCenter(t);
                            }
                            case 1: {
                                return this.bboxes[3].getNewCenter(t);
                            }
                            case 2: {
                                return this.bboxes[4].getNewCenter(t);
                            }
                            case 3: {
                                return this.bboxes[5].getNewCenter(t);
                            }
                        }
                        return this.bboxes[0].getNewCenter(t);
                    }
                    case 32: {
                        switch (shootablepart) {
                            case 0: {
                                return this.bboxes[2].getNewCenter(t);
                            }
                            case 1: {
                                return this.bboxes[3].getNewCenter(t);
                            }
                            case 2: {
                                return this.bboxes[4].getNewCenter(t);
                            }
                            case 3: {
                                return this.bboxes[5].getNewCenter(t);
                            }
                        }
                        return this.bboxes[0].getNewCenter(t);
                    }
                    case 33: {
                        switch (shootablepart) {
                            case 0: {
                                return this.bboxes[2].getNewCenter(t);
                            }
                            case 1: {
                                return this.bboxes[3].getNewCenter(t);
                            }
                            case 2: {
                                return this.bboxes[4].getNewCenter(t);
                            }
                            case 3: {
                                return this.bboxes[5].getNewCenter(t);
                            }
                        }
                        return this.bboxes[0].getNewCenter(t);
                    }
                }
                return this.bboxes[0].getNewCenter(t);
            }
            case 1: {
                return this.bboxes[0].getCenter();
            }
            case 2: {
                return this.bboxes[0].getCenter();
            }
        }
        return null;
    }

    private final boolean amITheActualTarget(Camera camera, Transform trans) {
        int h2;
        int w2;
        int y2;
        int x2;
        int h1;
        int w1;
        int y1;
        float[] pos = new float[4];
        Vector3D center = this.getCenterPoint(-1);
        pos[0] = center.getX();
        pos[1] = center.getY();
        pos[2] = center.getZ();
        pos[3] = 1.0f;
        int[] centerPos = Math3D.point3Dto2D(pos, camera, trans);
        int x1 = SniperGunCamera.getCursorXPosition() - 16 - 0;
        if (GameEngine.isIntersectingRec(x1, y1 = SniperGunCamera.getCursorYPosition() - 16 - 48, w1 = 32, h1 = 32, x2 = centerPos[0], y2 = centerPos[1], w2 = 2, h2 = 2)) {
            this.animateArrow = true;
            return true;
        }
        this.animateArrow = false;
        return false;
    }

    public final boolean updateShootableObject(Camera camera, Transform trans) {
        if (this.dying) {
            ++this.dyingBlink;
            if (this.dyingBlink > 10) {
                if (this.dyingBlink % 4 > 1) {
                    this.billboard.setRenderable(true);
                } else {
                    this.billboard.setRenderable(false);
                }
            }
            if (this.dyingBlink > 20 || !this.isAnEnemy()) {
                this.dyingBlink = 0;
                this.dying = false;
                this.desactivate(0);
                if (this.game.murders == this.game.terroristNumber) {
                    this.game.wait = true;
                    this.game.initWaitTime = GameEngine.gameTime;
                }
            }
            return false;
        }
        if (this.enemy) {
            return this.updateEnemy(camera, trans);
        }
        this.updateNoEnemy(camera, trans);
        return false;
    }

    private final void updateNoEnemy(Camera camera, Transform trans) {
        if (this.alive) {
            long elapsedTime;
            long actualT = GameEngine.getGameTime();
            if (this.amITheActualTarget(camera, trans) && !this.discovered) {
                this.initTrackingTime = actualT;
                this.discovered = true;
            }
            if (this.discovered && (elapsedTime = actualT - this.initTrackingTime) > 1400L && !this.endTracking) {
                this.initTimes(actualT);
                this.endTracking = true;
            }
            if (this.validTimes) {
                elapsedTime = actualT - this.initLifeTime;
                if (elapsedTime > this.lifeTime) {
                    this.desactivate(0);
                } else if (this.lifeTime - elapsedTime < 2000L) {
                    switch (this.visible) {
                        case 0: {
                            this.billboard.setVisible(true);
                            break;
                        }
                        default: {
                            this.billboard.setVisible(false);
                        }
                    }
                }
                this.visible = (byte)((this.visible + 1) % 2);
            }
        }
    }

    public final void desactivate(int index) {
        if (index >= 0 && index < this.shootableParts) {
            this.active[index] = false;
            if (this.category == 3) {
                SniperMIDlet.setOtherAttributes(false, false, this.objectMeshes[index + 2]);
            }
        }
        for (int i = 0; i < this.shootableParts; ++i) {
            if (!this.active[i]) continue;
            return;
        }
        this.alive = false;
    }

    private final boolean updateEnemy(Camera camera, Transform trans) {
        block7: {
            long elapsedTime;
            long actualT;
            block8: {
                if (!this.alive) break block7;
                actualT = GameEngine.getGameTime();
                if (this.renderWeaponLife && actualT - this.initRenderWeaponLife > 1500L) {
                    this.renderWeaponLife = false;
                }
                if (this.amITheActualTarget(camera, trans) && !this.discovered) {
                    this.initTrackingTime = actualT;
                    this.discovered = true;
                }
                if (this.discovered && (elapsedTime = actualT - this.initTrackingTime) >= 1400L && !this.endTracking) {
                    this.endTracking = true;
                }
                if (!this.validTimes) break block7;
                if (this.hasSeenPlayer) break block8;
                elapsedTime = actualT - this.initLifeTime;
                if (elapsedTime < this.timeToDiscoverPlayer) break block7;
                this.initShootingAnimation();
                if (!this.discovered) {
                    this.initTrackingTime = actualT;
                    this.discovered = true;
                }
                this.hasSeenPlayer = true;
                for (int i = 0; i < this.shootableParts; ++i) {
                    this.finalCount[i] = actualT;
                }
                break block7;
            }
            for (int i = 0; i < this.shootableParts; ++i) {
                if (!this.active[i] || (elapsedTime = actualT - this.finalCount[i]) < this.timeToShoot[i]) continue;
                if (this.category == 1) {
                    this.initShotSequence(i, this.bboxes[0].getCenter().getX(), this.bboxes[0].getCenter().getY(), this.bboxes[0].getCenter().getZ());
                }
                this.finalCount[i] = actualT;
                return this.goodHit(i);
            }
        }
        return false;
    }

    private final void initShotSequence(int index, float x, float y, float z) {
        this.shotSequence[index].setPosition(x, y, z);
        this.shotSequence[index].setVisible(true);
        this.shotSequence[index].validateAnimation(true);
    }

    private final boolean goodHit(int index) {
        switch (this.category) {
            case 1: {
                int top;
                switch (this.subCategory) {
                    case 51: {
                        top = 10;
                        break;
                    }
                    case 52: {
                        top = 10;
                        break;
                    }
                    case 53: {
                        top = 10;
                        break;
                    }
                    default: {
                        top = 10;
                    }
                }
                return Math3D.getRandNumber(1, 10) <= top;
            }
            case 3: {
                int top;
                AVPartInfo weaponInfo = (AVPartInfo)this.objectMeshes[index + 2].getUserObject();
                switch (weaponInfo.getExtremityType()) {
                    case 73: {
                        top = 1;
                        break;
                    }
                    case 72: {
                        top = 10;
                        break;
                    }
                    default: {
                        top = 1;
                    }
                }
                return Math3D.getRandNumber(1, 10) <= top;
            }
        }
        return true;
    }

    public final void renderArrow(Graphics g, int x, int y, boolean zoomOn) {
        int aniOffset;
        if (this.animateArrow) {
            this.arrowAngle = (short)(this.arrowAngle + 22);
            aniOffset = (int)(4.0 * Math.sin(Math.toRadians(this.arrowAngle)));
        } else {
            aniOffset = 0;
        }
        int offsetY = zoomOn ? -40 + aniOffset : -10 + aniOffset;
        g.fillTriangle(x, y + offsetY, x - 3, y - 6 + offsetY, x + 3, y - 6 + offsetY);
    }

    public final void renderWeaponLife(Graphics g, int x, int y, int side) {
        AVPartInfo meshlInfo = (AVPartInfo)this.objectMeshes[2 + side].getUserObject();
        float coef = meshlInfo.getCoef();
        int rectWidth = Math3D.linearInterpolation(0, 10, coef);
        int recty = y - 10;
        switch (side) {
            case 0: {
                int rectx = x + 10;
                g.setColor(-16777216);
                g.fillRect(rectx, recty, 12, 5);
                g.setColor(-12779776);
                g.fillRect(rectx + 1, recty + 1, rectWidth, 3);
                g.drawLine(rectx, recty + 5, x, y);
                g.drawArc(x - 3, y - 3, 6, 6, 0, 360);
                break;
            }
            case 1: {
                int rectx = x - 12 - 10;
                g.setColor(-16777216);
                g.fillRect(rectx, recty, 12, 5);
                g.setColor(-12779776);
                g.fillRect(rectx + 1, recty + 1, rectWidth, 3);
                g.drawLine(rectx + 12 - 1, recty + 5, x, y);
                g.drawArc(x - 3, y - 3, 6, 6, 0, 360);
                break;
            }
            case 2: {
                int rectx = x + 10;
                g.setColor(-16777216);
                g.fillRect(rectx, recty, 12, 5);
                g.setColor(-12779776);
                g.fillRect(rectx + 1, recty + 1, rectWidth, 3);
                g.drawLine(rectx, recty + 5, x, y);
                g.drawArc(x - 3, y - 3, 6, 6, 0, 360);
                break;
            }
            case 3: {
                int rectx = x - 12 - 10;
                g.setColor(-16777216);
                g.fillRect(rectx, recty, 12, 5);
                g.setColor(-12779776);
                g.fillRect(rectx + 1, recty + 1, rectWidth, 3);
                g.drawLine(rectx + 12 - 1, recty + 5, x, y);
                g.drawArc(x - 3, y - 3, 6, 6, 0, 360);
                break;
            }
        }
    }

    public final void renderTrackingMarks(Graphics g, int x, int y) {
        long elapsedTime = GameEngine.getGameTime() - this.initTrackingTime;
        int r = Math3D.linearInterpolation(60, 10, (float)elapsedTime * 1.0f / 1400.0f);
        this.angle = (short)((this.angle + 18) % 360);
        float alpha = this.angle % 360;
        float beta = (120.0f + alpha) % 360.0f;
        float gamma = (120.0f + beta) % 360.0f;
        float alpha1 = (float)Math.toRadians(alpha - 5.0f);
        float alpha2 = (float)Math.toRadians(alpha + 5.0f);
        float beta1 = (float)Math.toRadians(beta - 5.0f);
        float beta2 = (float)Math.toRadians(beta + 5.0f);
        float gamma1 = (float)Math.toRadians(gamma - 5.0f);
        float gamma2 = (float)Math.toRadians(gamma + 5.0f);
        int x6 = (int)(Math.cos(alpha1) * (double)r + (double)x);
        int y6 = (int)(Math.sin(alpha1) * (double)r + (double)y);
        int x1 = (int)(Math.cos(alpha2) * (double)r + (double)x);
        int y1 = (int)(Math.sin(alpha2) * (double)r + (double)y);
        int x2 = (int)(Math.cos(beta1) * (double)r + (double)x);
        int y2 = (int)(Math.sin(beta1) * (double)r + (double)y);
        int x3 = (int)(Math.cos(beta2) * (double)r + (double)x);
        int y3 = (int)(Math.sin(beta2) * (double)r + (double)y);
        int x4 = (int)(Math.cos(gamma1) * (double)r + (double)x);
        int y4 = (int)(Math.sin(gamma1) * (double)r + (double)y);
        int x5 = (int)(Math.cos(gamma2) * (double)r + (double)x);
        int y5 = (int)(Math.sin(gamma2) * (double)r + (double)y);
        g.setColor(-1);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x3, y3, x4, y4);
        g.drawLine(x5, y5, x6, y6);
    }

    private final void renderUbicationArrow(Graphics g, int x, int y) {
        int difY = y - 112;
        int difX = x - 120;
        float gamma = (float)Cordic.atanCordic((float)difY * 1.0f / ((float)difX * 1.0f));
        gamma = difY > 0 ? (difX > 0 ? (gamma < 0.0f ? (gamma += 90.0f) : (gamma += 0.0f)) : (gamma < 0.0f ? (gamma += 180.0f) : (gamma += 90.0f))) : (difX > 0 ? (gamma < 0.0f ? (gamma += 360.0f) : (gamma += 270.0f)) : (gamma < 0.0f ? (gamma += 270.0f) : (gamma += 180.0f)));
        float alpha = gamma + 195.0f;
        float beta = gamma + 165.0f;
        int p1X = (int)(Math.cos(Math.toRadians(gamma)) * 60.0 + 120.0);
        int p1Y = (int)(Math.sin(Math.toRadians(gamma)) * 60.0 + 112.0);
        int p2X = (int)(Math.cos(Math.toRadians(alpha)) * 10.0 + (double)p1X);
        int p2Y = (int)(Math.sin(Math.toRadians(alpha)) * 10.0 + (double)p1Y);
        int p3X = (int)(Math.cos(Math.toRadians(beta)) * 10.0 + (double)p1X);
        int p3Y = (int)(Math.sin(Math.toRadians(beta)) * 10.0 + (double)p1Y);
        g.drawLine(p1X, p1Y, p2X, p2Y);
        g.drawLine(p1X, p1Y, p3X, p3Y);
        g.drawLine(p2X, p2Y, p3X, p3Y);
    }

    private final void renderAnimatedConcentricCircles(Graphics g, float coef, int centerXCord, int centerYCord, boolean zoomOn) {
        int r = this.getRadiusToUse(coef, zoomOn);
        int r2 = r - 4;
        int d1 = r * 2;
        int d2 = r2 * 2;
        int xc1 = centerXCord - r;
        int yc1 = centerYCord - r;
        int xc2 = centerXCord - r2;
        int yc2 = centerYCord - r2;
        g.drawArc(xc1, yc1, d1, d1, 50, 80);
        g.drawArc(xc1, yc1, d1, d1, 140, 80);
        g.drawArc(xc1, yc1, d1, d1, 230, 80);
        g.drawArc(xc1, yc1, d1, d1, 320, 80);
        if (zoomOn) {
            int markSize = 3;
            int size = r2 - markSize;
            g.drawLine(centerXCord - r2, centerYCord, centerXCord - size, centerYCord);
            g.drawLine(centerXCord + r2, centerYCord, centerXCord + size, centerYCord);
            g.drawLine(centerXCord, centerYCord - r2, centerXCord, centerYCord - size);
            g.drawLine(centerXCord, centerYCord + r2, centerXCord, centerYCord + size);
            int x1 = Math3D.linearInterpolation(r + markSize, 0, coef);
            int y1 = this.calculateYValue(x1, r + markSize, 0, 0);
            int x2 = Math3D.linearInterpolation(r2 - markSize, 0, coef);
            int y2 = this.calculateYValue(x2, r2 - markSize, 0, 0);
            g.drawLine(centerXCord - x1, centerYCord - y1, centerXCord - x2, centerYCord - y2);
            g.drawLine(centerXCord - x1, centerYCord + y1, centerXCord - x2, centerYCord + y2);
            g.drawLine(centerXCord + x1, centerYCord - y1, centerXCord + x2, centerYCord - y2);
            g.drawLine(centerXCord + x1, centerYCord + y1, centerXCord + x2, centerYCord + y2);
        }
        if (SniperMIDlet.drawDebug) {
            g.setColor(65535);
            g.drawString("" + this.positionIndex, centerXCord, centerYCord - 15, 33);
        }
    }

    private final void renderWarningMarksForEnemies(Graphics g, Camera camera, Transform trans, boolean zoomOn) {
        float[] pos = new float[4];
        for (int i = 0; i < this.shootableParts; ++i) {
            int warningColor;
            float coef;
            long elapsedTime;
            if (!this.active[i]) continue;
            Vector3D center = this.getCenterPoint(i);
            pos[0] = center.getX();
            pos[1] = center.getY();
            pos[2] = center.getZ();
            pos[3] = 1.0f;
            int[] centerPos = Math3D.point3Dto2D(pos, camera, trans);
            if (this.discovered && !this.endTracking) {
                this.renderTrackingMarks(g, centerPos[0], centerPos[1]);
            }
            if (!this.validTimes) continue;
            if (this.hasSeenPlayer) {
                int red;
                int green;
                elapsedTime = GameEngine.getGameTime() - this.finalCount[i];
                coef = (float)elapsedTime * 1.0f / ((float)this.timeToShoot[i] * 1.0f);
                if (coef < 0.5f) {
                    green = 255;
                    red = Math3D.linearInterpolation(0, 255, coef * 2.0f);
                } else {
                    red = 255;
                    green = Math3D.linearInterpolation(255, 0, (coef - 0.5f) * 2.0f);
                }
                warningColor = 0xFF000000 | (red <<= 16) | (green <<= 8);
            } else {
                elapsedTime = GameEngine.getGameTime() - this.initLifeTime;
                coef = (float)elapsedTime * 1.0f / ((float)this.timeToDiscoverPlayer * 1.0f);
                warningColor = -1;
            }
            g.setColor(warningColor);
            if (this.discovered) {
                this.renderArrow(g, centerPos[0], centerPos[1], zoomOn);
                if (this.category == 3 && zoomOn && this.renderWeaponLife && i == this.side) {
                    this.renderWeaponLife(g, centerPos[0], centerPos[1], i);
                    g.setColor(warningColor);
                }
            }
            if (SniperCanvas.isInsideScreenCoordinates(centerPos[0], centerPos[1])) {
                if (!zoomOn) continue;
                this.renderAnimatedConcentricCircles(g, coef, centerPos[0], centerPos[1], zoomOn);
                continue;
            }
            if (!zoomOn) continue;
            this.renderUbicationArrow(g, centerPos[0], centerPos[1]);
        }
        if (this.category == 1) {
            this.updateShotSequence();
        }
    }

    private final void renderWarningMarksForNoEnemies(Graphics g, Camera camera, Transform trans, boolean zoomOn) {
        if (this.active != null && this.active[0]) {
            float[] pos = new float[4];
            Vector3D center = this.getCenterPoint(-1);
            pos[0] = center.getX();
            pos[1] = center.getY();
            pos[2] = center.getZ();
            pos[3] = 1.0f;
            int[] centerPos = Math3D.point3Dto2D(pos, camera, trans);
            if (this.category == 1) {
                g.setColor(-1);
            } else {
                g.setColor(-16776961);
            }
            if (this.discovered) {
                if (!this.endTracking) {
                    this.renderTrackingMarks(g, centerPos[0], centerPos[1]);
                }
                this.renderArrow(g, centerPos[0], centerPos[1], zoomOn);
            }
            if (this.validTimes) {
                long elapsedTime = GameEngine.getGameTime() - this.initLifeTime;
                float coef = (float)elapsedTime * 1.0f / ((float)this.lifeTime * 1.0f);
                if (SniperCanvas.isInsideScreenCoordinates(centerPos[0], centerPos[1])) {
                    if (zoomOn) {
                        this.renderAnimatedConcentricCircles(g, coef, centerPos[0], centerPos[1], zoomOn);
                    }
                } else if (zoomOn) {
                    this.renderUbicationArrow(g, centerPos[0], centerPos[1]);
                }
            }
        }
    }

    public final void renderWarningMarks(Graphics g, Camera camera, Transform trans, boolean zoomOn) {
        block1 : switch (this.category) {
            case 2: {
                this.renderWarningMarksForNoEnemies(g, camera, trans, zoomOn);
                break;
            }
            case 1: {
                switch (this.subCategory) {
                    case 50: {
                        this.renderWarningMarksForNoEnemies(g, camera, trans, zoomOn);
                        break block1;
                    }
                }
                try {
                    this.renderWarningMarksForEnemies(g, camera, trans, zoomOn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                this.renderWarningMarksForEnemies(g, camera, trans, zoomOn);
            }
        }
    }
}

