/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.util.Random;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Transform;
import z.Vector3D;

public class Math3D {
    public static final int MAX_ITERATIONS = 100;
    public static final double TOLERANCE = 1.0E-9;
    public static final float kPi = (float)Math.PI;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;
    public static final float k2Pi = (float)Math.PI * 2;
    public static final float kPiOver2 = 1.5707964f;
    public static final float k1OverPi = 0.31830987f;
    public static final float k1Over2Pi = 0.15915494f;
    private static Random rnd = new Random(System.currentTimeMillis());
    public static final int HALF_RAND = 0x3FFFFFFF;

    public static final float RandomNum() {
        int rn = rnd.nextInt(Integer.MAX_VALUE);
        return (float)(rn - 0x3FFFFFFF) / 1.0737418E9f;
    }

    public static final int getRandNumber(int min, int max) {
        int r = Math.abs(rnd.nextInt());
        return r % (max - min + 1) + min;
    }

    public static final Vector3D rotationToDirection(float pitch, float yaw) {
        float x = (float)(-Math.sin(yaw) * Math.cos(pitch));
        float y = (float)Math.sin(pitch);
        float z = (float)(Math.cos(pitch) * Math.cos(yaw));
        return new Vector3D(x, y, z);
    }

    public static final float[] multiplyMatrices(float[] matrixA, float[] matrixB, int rowsA, int columnsA, int rowsB, int columnsB) {
        if (columnsA != rowsB) {
            System.out.println("We cannot multiply the matrices passed as argument");
            return null;
        }
        int rowsC = rowsA;
        int columnsC = columnsB;
        float[] matrixC = new float[rowsC * columnsC];
        for (int w = 0; w < matrixC.length; ++w) {
            matrixC[w] = 0.0f;
        }
        for (int i = 0; i < rowsC; ++i) {
            for (int j = 0; j < columnsC; ++j) {
                for (int k = 0; k < columnsA; ++k) {
                    int n = i * columnsC + j;
                    matrixC[n] = matrixC[n] + matrixA[i * columnsA + k] * matrixB[k * columnsB + j];
                }
            }
        }
        return matrixC;
    }

    public static final float wrapPi(float theta) {
        theta += (float)Math.PI;
        theta = (float)((double)theta - Math.floor(theta * 0.15915494f) * 6.2831854820251465);
        return theta -= (float)Math.PI;
    }

    public static boolean pointInsideEllipse(int x, int y, int h, int k, int a, int b) {
        double coef2;
        double coef1 = Math3D.pow(x - h, 2) / Math3D.pow(a, 2);
        return coef1 + (coef2 = Math3D.pow(y - k, 2) / Math3D.pow(b, 2)) <= 1.0;
    }

    public static boolean pointInBorderCircle(int x, int y, int h, int k, int radius) {
        double coef2;
        double gap = 0.09;
        double coef1 = Math3D.pow(x - h, 2) / Math3D.pow(radius, 2);
        return coef1 + (coef2 = Math3D.pow(y - k, 2) / Math3D.pow(radius, 2)) <= 1.0 && coef1 + coef2 >= 1.0 - gap;
    }

    public static final double pow(double x, int y) {
        double z = 1.0;
        if (y >= 0) {
            while (true) {
                if ((y & 1) != 0) {
                    z *= x;
                }
                if ((y >>= 1) != 0) {
                    x *= x;
                    continue;
                }
                break;
            }
        } else {
            y = -y;
            while (true) {
                if ((y & 1) != 0) {
                    z /= x;
                }
                if ((y >>= 1) == 0) break;
                x *= x;
            }
        }
        return z;
    }

    public static final double exp(float x) {
        boolean reciprocal;
        double eps = 1.0E-6;
        double xlocal = Math.abs(x);
        boolean bl = reciprocal = (double)x < 0.0;
        if (x == 0.0f) {
            return 1.0;
        }
        if (x == 1.0f) {
            return Math.E;
        }
        double oldval = 1.0;
        double num = xlocal;
        int count = 1;
        double denom = 1.0;
        double newval = oldval + num / denom;
        while (Math.abs(newval - oldval) > eps) {
            oldval = newval;
            newval = oldval + (num *= xlocal) / (denom *= (double)(++count));
        }
        if (reciprocal) {
            newval = 1.0 / newval;
        }
        return newval;
    }

    public static final double log(double x) {
        double xlocal;
        double eps = 1.0E-6;
        if (x <= 0.0) {
            System.out.println("Argument incorret");
            return x;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x == Math.E) {
            return 1.0;
        }
        double oldval = xlocal = (x - 1.0) / (x + 1.0);
        double xlocalsqr = Math3D.pow(xlocal, 2);
        double factor = xlocal * xlocalsqr;
        int count = 3;
        double newval = oldval + factor / ((double)count * 1.0);
        while (Math.abs(newval - oldval) > eps) {
            oldval = newval;
            newval = oldval + (factor *= xlocalsqr) / ((double)(count += 2) * 1.0);
        }
        return newval *= 2.0;
    }

    public static final double log(int base, double x) {
        if (base <= 0 | x <= 0.0) {
            System.out.println("Incorrect parameters");
            return x;
        }
        return Math3D.log(x) / Math3D.log((double)base * 1.0);
    }

    public static final double newtonRaphsonRF(int nthRoot, float value) {
        double x1 = 0.5 * (double)value;
        for (int i = 0; i < 100; ++i) {
            double dfdx;
            double x0 = x1;
            double f = Math3D.pow(x0, nthRoot) - (double)value;
            if (!(Math.abs((x1 = x0 - f / (dfdx = (double)nthRoot * Math3D.pow(x0, nthRoot - 1))) - x0) <= 1.0E-9)) continue;
            return x1;
        }
        return x1;
    }

    public static final double sqrt(float value) {
        return Math3D.newtonRaphsonRF(2, value);
    }

    public static final int integerSquareRooting(int x) {
        int base = 128;
        int y = 0;
        for (int i = 1; i <= 8; ++i) {
            if ((y += base) * y > x) {
                y -= base;
            }
            base >>= 1;
        }
        return y;
    }

    public static int linearInterpolation(int startV, int endV, float coef) {
        if (coef <= 0.0f) {
            return startV;
        }
        if (coef >= 1.0f) {
            return endV;
        }
        return (int)((float)startV + coef * (float)(endV - startV));
    }

    public static float linearInterpolation(float startV, float endV, float coef) {
        if (coef <= 0.0f) {
            return startV;
        }
        if (coef >= 1.0f) {
            return endV;
        }
        return startV + coef * (endV - startV);
    }

    public static int[] point3Dto2D(float[] point3D, Camera cam, Transform modelView) {
        int[] points2D = new int[2];
        Transform model = new Transform(modelView);
        model.invert();
        Transform t = new Transform();
        cam.getProjection(t);
        t.postMultiply(model);
        t.transform(point3D);
        float w = 1.0f / point3D[3];
        float xNDC = point3D[0] * w;
        float yNDC = point3D[1] * w;
        points2D[0] = (int)(0.5f * xNDC * 240.0f + 120.0f);
        points2D[1] = (int)(-0.5f * yNDC * 224.0f + 112.0f);
        return points2D;
    }
}

