/*
 * Decompiled with CFR 0.152.
 */
package z;

import z.Math3D;

public class Cordic {
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte Z = 2;
    public static final int MAXBITS = 21;
    public static final double[] ATAN_TABLE = new double[]{45.0, 26.56505, 14.03624, 7.125016, 3.576334, 1.789911, 0.8951737, 0.4476142, 0.2238105, 0.1119057, 0.05595289, 0.02797645, 0.01398823, 0.006994114, 0.003497057, 0.001748528, 8.742642E-4, 4.371321E-4, 2.185661E-4, 1.09283E-4, 5.464151E-5};
    public static final double[] ATAN_H_TABLE = new double[]{0.5493061, 0.2554128, 0.1256572, 0.06258157, 0.03126018, 0.01562627, 0.007812659, 0.00390627, 0.001953127, 9.765628E-4, 4.882813E-4, 2.441406E-4, 1.220703E-4, 6.103516E-5, 3.051758E-5, 1.525879E-5, 7.629395E-6, 3.814697E-6, 1.907349E-6, 9.536743E-7, 4.768372E-7};
    public static final double INVGAIN2 = 1.0 / Cordic.gain2Cordic();
    public static final double INVGAIN1 = 1.0 / Cordic.gain1Cordic();

    private static final void cordit1(double[] vector, double vecmode) {
        double t = 1.0;
        double x = vector[0];
        double y = vector[1];
        double z = vector[2];
        for (int i = 0; i < 21; ++i) {
            double x1;
            if (vecmode >= 0.0 && y < vecmode || vecmode < 0.0 && z >= 0.0) {
                x1 = x - y * t;
                y += x * t;
                z -= ATAN_TABLE[i];
            } else {
                x1 = x + y * t;
                y -= x * t;
                z += ATAN_TABLE[i];
            }
            x = x1;
            t /= 2.0;
        }
        vector[0] = x;
        vector[1] = y;
        vector[2] = z;
    }

    private static final void cordit2(double[] vector, double vecmode) {
        double t = 0.5;
        double x = vector[0];
        double y = vector[1];
        double z = vector[2];
        int k = 3;
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 2; ++j) {
                double x1;
                if (vecmode >= 0.0 && y < 0.0 || vecmode < 0.0 && z >= 0.0) {
                    x1 = x + y * t;
                    y += x * t;
                    z -= ATAN_H_TABLE[i];
                } else {
                    x1 = x - y * t;
                    y -= x * t;
                    z += ATAN_H_TABLE[i];
                }
                x = x1;
                if (k != 0) {
                    --k;
                    break;
                }
                k = 3;
            }
            t /= 2.0;
        }
        vector[0] = x;
        vector[1] = y;
        vector[2] = z;
    }

    private static final void cordit0(double[] vector, double vecmode) {
        double t = 1.0;
        double x = vector[0];
        double y = vector[1];
        double z = vector[2];
        for (int i = 0; i < 21; ++i) {
            if (vecmode >= 0.0 && y < 0.0 || vecmode < 0.0 && z >= 0.0) {
                y += x * t;
                z -= t;
            } else {
                y -= x * t;
                z += t;
            }
            t /= 2.0;
        }
        vector[0] = x;
        vector[1] = y;
        vector[2] = z;
    }

    private static final double divCordic(double a, double b) {
        double[] vector = new double[]{b, a, 0.0};
        Cordic.cordit0(vector, 0.0);
        System.out.println("El resultado de dividir " + a + " entre " + b + " es : " + vector[2]);
        return vector[2];
    }

    private static final double gain1Cordic() {
        double[] vector = new double[]{1.0, 0.0, 0.0};
        Cordic.cordit1(vector, -1.0);
        return vector[0];
    }

    public static final double atanCordic(double a) {
        double[] vector = new double[]{1.0, a, 0.0};
        Cordic.cordit1(vector, 0.0);
        return vector[2];
    }

    public static final double sincosCordic(double a, double[] cosp) {
        double[] vector = new double[]{INVGAIN1, 0.0, a};
        Cordic.cordit1(vector, -1.0);
        cosp[0] = vector[0];
        return vector[1];
    }

    public static final double sinCordic(double a) {
        double[] vector = new double[]{INVGAIN1, 0.0, a};
        Cordic.cordit1(vector, -1.0);
        return vector[1];
    }

    public static final double cosCordic(double a) {
        double[] vector = new double[]{INVGAIN1, 0.0, a};
        Cordic.cordit1(vector, -1.0);
        return vector[0];
    }

    public static final double tanCordic(double a) {
        double[] vector = new double[]{INVGAIN1, 0.0, a};
        Cordic.cordit1(vector, -1.0);
        return Cordic.divCordic(vector[1], vector[0]);
    }

    public static final double asinCordic(double a) {
        if (Math.abs(a) > 1.0) {
            System.out.println("Out of range parameter passed to asinCordic");
            return a;
        }
        if (Math.abs(a) < 0.9) {
            return Cordic.atanCordic(a / Math3D.sqrt((float)(1.0 - a * a)));
        }
        if (a > 0.0) {
            return 90.0 - Cordic.atanCordic(Math3D.sqrt((float)(1.0 - a * a)) / a);
        }
        return -90.0 + Cordic.atanCordic(Math3D.sqrt((float)(1.0 - a * a)) / a);
    }

    public static final double acosCordic(double a) {
        if (Math.abs(a) > 1.0) {
            System.out.println("Out of range parameter passed to acosCordic");
            return a;
        }
        if (Math.abs(a) > 0.9) {
            if (a > 0.0) {
                return Cordic.atanCordic(Math3D.sqrt((float)(1.0 - a * a)) / a);
            }
            return 180.0 - Cordic.atanCordic(Math3D.sqrt((float)(1.0 - a * a)) / a);
        }
        return 90.0 - Cordic.atanCordic(a / Math3D.sqrt((float)(1.0 - a * a)));
    }

    private static final double gain2Cordic() {
        double[] vector = new double[]{1.0, 0.0, 0.0};
        Cordic.cordit2(vector, -1.0);
        return vector[0];
    }

    public static final double sinhcoshCordic(double a, double[] coshp) {
        double[] vector = new double[]{INVGAIN2, 0.0, a};
        Cordic.cordit2(vector, -1.0);
        coshp[0] = vector[0];
        return vector[1];
    }

    public static final double tanhCordic(double a) {
        double[] vector = new double[]{INVGAIN2, 0.0, a};
        Cordic.cordit2(vector, -1.0);
        return Cordic.divCordic(vector[1], vector[0]);
    }

    public static final double atanhCordic(double a) {
        double[] vector = new double[]{1.0, a, 0.0};
        Cordic.cordit2(vector, 0.0);
        return vector[2];
    }

    public static final double logCordic(double a) {
        double[] vector = new double[]{a + 1.0, a - 1.0, 0.0};
        Cordic.cordit2(vector, 0.0);
        return 2.0 * vector[2];
    }

    public static final double expCordic(double a) {
        double[] vector = new double[]{INVGAIN2, 0.0, a};
        Cordic.cordit2(vector, -1.0);
        return vector[1] + vector[0];
    }
}

