/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteObject {
    private static final short IZ_HEAD_W = 5;
    private static final short IZ_HEAD_H = 5;
    private static final short IZ_ARM_W = 9;
    private static final short IZ_ARM_H = 12;
    private static final short IZ_TRUNK_W = 9;
    private static final short IZ_TRUNK_H = 11;
    private static final short IZ_LEG_W = 6;
    private static final short IZ_LEG_H = 23;
    short[][] sprites;
    short[][] frames;
    long[][] frameTimings;
    Image imageSet;
    short actualFrameIndex = 0;
    short despX;
    short despY;
    long animationLength = 0L;
    long startingTime;
    boolean continuous;

    public SpriteObject(Image anImage) {
        this.imageSet = anImage;
    }

    private void initFrameTimings() {
        this.frameTimings = new long[this.frames.length][];
        long initTime = 0L;
        long finalTime = 0L;
        for (int i = 0; i < this.frames.length; ++i) {
            initTime = finalTime;
            finalTime = initTime + (long)this.frames[i][3];
            long[] timing = new long[]{initTime, finalTime};
            this.frameTimings[i] = timing;
        }
        this.animationLength = finalTime;
    }

    public final boolean draw(Graphics g, long time) {
        int frameId = this.getActualFrameIndex(time);
        return this.drawSpecifiedFrame(g, frameId);
    }

    public final boolean drawSpecifiedFrame(Graphics g, int frameId) {
        if (frameId < 0 || frameId >= this.frames.length) {
            return false;
        }
        short spriteId = this.frames[frameId][0];
        g.clipRect(this.frames[frameId][1] + this.despX, this.frames[frameId][2] + this.despY, (int)this.sprites[spriteId][2], (int)this.sprites[spriteId][3]);
        g.drawImage(this.imageSet, this.frames[frameId][1] - this.sprites[spriteId][0] + this.despX, this.frames[frameId][2] - this.sprites[spriteId][1] + this.despY, 0);
        return true;
    }

    public final boolean drawSpecifiedSprite(Graphics g, int spriteId) {
        if (spriteId < 0 || spriteId >= this.sprites.length) {
            return false;
        }
        g.clipRect((int)this.despX, (int)this.despY, (int)this.sprites[spriteId][2], (int)this.sprites[spriteId][3]);
        g.drawImage(this.imageSet, -this.sprites[spriteId][0] + this.despX, -this.sprites[spriteId][1] + this.despY, 0);
        return true;
    }

    public final int getActualFrameIndex(long time) {
        long t = time - this.startingTime;
        if (t > this.animationLength) {
            if (this.continuous) {
                t %= this.animationLength;
            } else {
                return -1;
            }
        }
        if (t < this.frameTimings[this.actualFrameIndex][0]) {
            this.actualFrameIndex = 0;
        }
        while (t > this.frameTimings[this.actualFrameIndex][1]) {
            this.actualFrameIndex = (short)(this.actualFrameIndex + 1);
            if (this.actualFrameIndex < this.frameTimings.length) continue;
            return -1;
        }
        return this.actualFrameIndex;
    }

    public final void initImpactZonesSprites(short xOffset, short yOffset) {
        this.despX = xOffset;
        this.despY = yOffset;
        this.continuous = false;
        short[][] spritesTmp = new short[][]{{9, 6, 9, 11}, {11, 0, 5, 5}, {0, 7, 9, 12}, {18, 7, 9, 12}, {8, 18, 6, 23}, {13, 18, 6, 23}};
        short[][] framesTmp = new short[][]{{0, 9, 6, 100}, {1, 11, 0, 100}, {2, 0, 7, 100}, {3, 18, 7, 100}, {4, 8, 18, 100}, {5, 13, 18, 100}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }

    public final void initSparkSprites() {
        this.despX = 0;
        this.despY = 0;
        this.continuous = false;
        short[][] spritesTmp = new short[][]{{0, 0, 10, 10}, {10, 0, 10, 10}, {20, 0, 10, 10}};
        short[][] framesTmp = new short[][]{{0, -5, -5, 75}, {1, -5, -5, 75}, {2, -5, -5, 75}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }

    public final void initGrades() {
        this.despX = 0;
        this.despY = 0;
        this.continuous = false;
        short[][] spritesTmp = new short[][]{{0, 0, 15, 19}, {15, 0, 18, 19}, {33, 0, 17, 19}, {49, 0, 17, 19}, {66, 0, 17, 19}};
        short[][] framesTmp = new short[][]{{0, 0, 0, 100}, {1, 0, 0, 100}, {2, 0, 0, 100}, {3, 0, 0, 100}, {4, 0, 0, 100}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }

    public final void initBulletsSprites() {
        this.despX = 0;
        this.despY = 0;
        this.continuous = false;
        short[][] spritesTmp = new short[][]{{5, 16, 26, 5}, {21, 0, 19, 11}, {0, 0, 5, 19}, {5, 0, 16, 16}, {21, 11, 19, 5}};
        short[][] framesTmp = new short[][]{{0, 146, 167, 50}, {1, 146, 158, 50}, {2, 147, 146, 50}, {3, 138, 147, 50}, {4, 133, 168, 50}, {3, 133, 181, 50}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }

    public final void initHelicopterBlades() {
        this.despX = 0;
        this.despY = 0;
        this.continuous = true;
        short[][] spritesTmp = new short[][]{{0, 0, 90, 51}, {0, 51, 90, 47}, {0, 98, 90, 41}};
        short[][] framesTmp = new short[][]{{0, -6, -27, 50}, {1, -4, -26, 50}, {2, -6, -23, 50}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }

    public final void initCityDistrict() {
        this.despX = 0;
        this.despY = 0;
        this.continuous = true;
        short[][] spritesTmp = new short[][]{{0, 0, 42, 25}, {42, 0, 42, 25}, {0, 25, 43, 55}, {43, 25, 36, 47}};
        short[][] framesTmp = new short[][]{{0, 32, 33, 50}, {1, 84, 36, 50}, {2, 49, 67, 50}, {3, 114, 73, 50}};
        this.sprites = spritesTmp;
        this.frames = framesTmp;
        this.initFrameTimings();
    }
}

